/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.events.KitEventHandler;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class KayaKit
extends AbstractKit
implements Listener {
    public static final KayaKit INSTANCE = new KayaKit();
    private final NamespacedKey namespacedKey;
    private final String kayaBlockKey;
    private final ItemStack kayaBlock;

    private KayaKit() {
        super("Kaya", Material.GRASS_BLOCK);
        this.kayaBlockKey = "kayaBlock";
        this.namespacedKey = new NamespacedKey((Plugin)KitApi.getInstance().getPlugin(), this.kayaBlockKey);
        this.kayaBlock = new ItemBuilder(Material.GRASS_BLOCK).setName(ChatColor.GREEN + "Kaya Block").build();
        this.addAdditionalKitItems(new ItemBuilder(this.kayaBlock.clone()).setAmount(16).build());
        this.setKitItemPlaceable(true);
        this.registerRecipe();
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> player.discoverRecipe(this.namespacedKey));
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> player.undiscoverRecipe(this.namespacedKey));
    }

    @KitEvent
    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!event.getItemInHand().isSimilar(this.kayaBlock)) {
            return;
        }
        if (!KitEventHandler.canUseKit((Event)event, kitPlayer, this)) {
            event.setCancelled(true);
            return;
        }
        event.getBlockPlaced().setMetadata(this.kayaBlockKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnGround()) {
            return;
        }
        if (event.getTo().distanceSquared(event.getFrom()) == 0.0) {
            return;
        }
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (kitPlayer.hasKit(this)) {
            return;
        }
        if (!kitPlayer.isValid()) {
            return;
        }
        Block block = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
        if (block.getType().equals((Object)this.kayaBlock.getType()) && block.hasMetadata(this.kayaBlockKey)) {
            Localization.INSTANCE.getMessage("kaya.triggerBlock", ChatUtils.locale((Player)player));
            block.setType(Material.AIR);
        }
    }

    private void registerRecipe() {
        ShapelessRecipe recipe = new ShapelessRecipe(this.namespacedKey, this.kayaBlock);
        recipe.addIngredient(Material.WHEAT_SEEDS);
        recipe.addIngredient(Material.DIRT);
        Bukkit.addRecipe((Recipe)recipe);
    }

    public ItemStack getKayaBlock() {
        return this.kayaBlock;
    }
}

