/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class JackhammerKit
extends AbstractKit {
    public static final JackhammerKit INSTANCE = new JackhammerKit();
    @IntArg
    private final int maxUses = 5;
    @FloatArg(min=0.0f)
    private final float cooldown;

    private JackhammerKit() {
        super("Jackhammer", Material.STONE_AXE);
        this.cooldown = 20.0f;
        this.setMainKitItem(this.getDisplayMaterial(), true);
    }

    @Override
    @KitEvent
    public void onBlockBreakWithKitItem(BlockBreakEvent e) {
        Location blockLoc = e.getBlock().getLocation();
        Block above = blockLoc.clone().add(0.0, 1.0, 0.0).getBlock();
        Block below = blockLoc.clone().subtract(0.0, 1.0, 0.0).getBlock();
        if (above.getType().isAir() || above.getType().getHardness() == 100.0f) {
            this.dig(blockLoc, -1, 1);
        } else if (below.getType().isAir() || below.getType().getHardness() == 100.0f) {
            this.dig(blockLoc, 1, 1);
        } else {
            this.dig(blockLoc, 1, 2);
            this.dig(blockLoc, -1, 2);
        }
        KitApi.getInstance().checkUsesForCooldown(e.getPlayer(), (AbstractKit)this, 5);
    }

    private void dig(Location loc, int direction, int delay) {
        Location currentLocation = loc.clone();
        Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), bukkitTask -> {
            if (!Utils.isUnbreakableLaborBlock(currentLocation.getBlock())) {
                currentLocation.getBlock().setType(Material.AIR);
                loc.getWorld().spawnParticle(Particle.ASH, currentLocation.clone().add(0.5, 0.0, 0.5), 10);
                currentLocation.add(0.0, (double)direction, 0.0);
                if (currentLocation.getBlock().getType() == Material.BEDROCK) {
                    bukkitTask.cancel();
                }
            } else {
                bukkitTask.cancel();
            }
        }, 0L, (long)delay);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

