/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.BoolArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GripperKit
extends AbstractKit {
    public static final GripperKit INSTANCE = new GripperKit();
    private final Material[] disabledBlocks = new Material[]{Material.BEDROCK, Material.OBSIDIAN, Material.BARRIER};
    @FloatArg(min=0.0f)
    private final float cooldown;
    @BoolArg
    private final boolean canGrabBlocks;
    private final String grippedEntityKey = "grippedEntity";
    private final String runnableKey = "gripperRunnable";

    private GripperKit() {
        super("Gripper", Material.MINECART);
        this.setMainKitItem(this.getDisplayMaterial());
        this.cooldown = 8.0f;
        this.canGrabBlocks = true;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    @Override
    public void onEnable(final KitPlayer kitPlayer) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                Optional<Player> optionalPlayer;
                Entity grippedEntity = (Entity)kitPlayer.getKitAttribute("grippedEntity");
                if (grippedEntity != null && (optionalPlayer = kitPlayer.getBukkitPlayer()).isPresent()) {
                    Player player = optionalPlayer.get();
                    if (player.getInventory().getItemInMainHand().isSimilar(GripperKit.this.getMainKitItem())) {
                        if (grippedEntity instanceof Player && ((Player)grippedEntity).isSneaking()) {
                            kitPlayer.putKitAttribute("grippedEntity", null);
                            kitPlayer.activateKitCooldown(INSTANCE);
                        }
                        Location location = player.getLocation().clone().add(player.getLocation().clone().getDirection().normalize().multiply(3));
                        location.setYaw(grippedEntity.getLocation().getYaw());
                        location.setPitch(grippedEntity.getLocation().getPitch());
                        if (location.getBlock().getType() == Material.AIR && location.clone().add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR) {
                            grippedEntity.teleport(location);
                        }
                    } else {
                        kitPlayer.putKitAttribute("grippedEntity", null);
                    }
                }
            }
        }.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 2L, 1L);
        kitPlayer.putKitAttribute("gripperRunnable", bukkitTask);
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        BukkitTask bukkitTask = (BukkitTask)kitPlayer.getKitAttribute("gripperRunnable");
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickLivingEntityWithKitItem(PlayerInteractAtEntityEvent event, KitPlayer kitPlayer, LivingEntity entity) {
        Entity grippedEntity = (Entity)kitPlayer.getKitAttribute("grippedEntity");
        if (grippedEntity == null) {
            entity.getWorld().playSound(entity.getLocation(), Sound.BLOCK_PISTON_CONTRACT, 1.0f, 1.0f);
            kitPlayer.putKitAttribute("grippedEntity", entity);
        } else {
            grippedEntity.getWorld().playSound(grippedEntity.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 10.0f);
            kitPlayer.getBukkitPlayer().ifPresent(it -> it.sendMessage(Localization.INSTANCE.getMessage("gripper.alreadyGripped", ChatUtils.locale((Player)it))));
        }
        event.setCancelled(true);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (event.hasBlock() && this.canGrabBlocks) {
            Block block = event.getClickedBlock();
            if (block == null || event.isCancelled()) {
                return;
            }
            if (List.of(this.disabledBlocks).contains(block.getType())) {
                return;
            }
            FallingBlock grippedBlock = (FallingBlock)kitPlayer.getKitAttribute("grippedEntity");
            if (grippedBlock != null) {
                player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 10.0f);
                kitPlayer.getBukkitPlayer().ifPresent(it -> it.sendMessage(Localization.INSTANCE.getMessage("gripper.alreadyGripped", ChatUtils.locale((Player)it))));
            } else {
                FallingBlock fallingBlock = player.getWorld().spawnFallingBlock(player.getLocation(), block.getBlockData());
                fallingBlock.setGravity(false);
                kitPlayer.putKitAttribute("grippedEntity", fallingBlock);
                block.setType(Material.AIR);
            }
        }
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Entity grippedEntity = (Entity)kitPlayer.getKitAttribute("grippedEntity");
        if (grippedEntity != null) {
            kitPlayer.putKitAttribute("grippedEntity", null);
            grippedEntity.getWorld().playSound(grippedEntity.getLocation(), Sound.BLOCK_PISTON_EXTEND, 1.0f, 1.0f);
            grippedEntity.setVelocity(event.getPlayer().getLocation().getDirection().multiply(1.3));
            kitPlayer.activateKitCooldown(this);
        }
    }
}

