/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.MaterialArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.WorldEditUtils;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GladiatorKit
extends AbstractKit
implements Listener {
    public static final GladiatorKit INSTANCE = new GladiatorKit();
    @IntArg(min=3)
    private final int radius;
    @IntArg(min=3)
    private final int height;
    @MaterialArg
    private final Material material;
    @DoubleArg
    private final double intruderDamage;
    @IntArg
    private final int witherEffectAfterXSeconds;
    private final String attributeKey;

    private GladiatorKit() {
        super("Gladiator", Material.IRON_BARS);
        this.setMainKitItem(this.getDisplayMaterial());
        this.radius = 15;
        this.height = 10;
        this.witherEffectAfterXSeconds = 120;
        this.intruderDamage = 5.0;
        this.material = Material.GLASS;
        this.attributeKey = this.getName() + "Fight";
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        GladiatorFight value = (GladiatorFight)((Object)kitPlayer.getKitAttribute(this.attributeKey));
        if (value != null) {
            value.endFight();
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickPlayerWithKitItem(PlayerInteractAtEntityEvent event, KitPlayer kitPlayer, Player rightClicked) {
        Player player = event.getPlayer();
        org.bukkit.World world = player.getWorld();
        if (player.hasMetadata(KitMetaData.INGLADIATOR.getKey()) || rightClicked.hasMetadata(KitMetaData.INGLADIATOR.getKey())) {
            return;
        }
        rightClicked.getPassengers().forEach(Entity::leaveVehicle);
        rightClicked.setMetadata(KitMetaData.INGLADIATOR.getKey(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
        player.setMetadata(KitMetaData.INGLADIATOR.getKey(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
        Region gladiatorRegion = this.getGladiatorLocation(player.getLocation().clone().set(player.getLocation().getX(), 90.0, player.getLocation().getZ()), this.radius, this.height + 2);
        Location center = BukkitAdapter.adapt((org.bukkit.World)world, (Vector3)gladiatorRegion.getCenter());
        WorldEditUtils.createCylinder((org.bukkit.World)player.getWorld(), (Location)center, (int)(this.radius - 1), (boolean)true, (int)1, (Material)this.material);
        WorldEditUtils.createCylinder((org.bukkit.World)player.getWorld(), (Location)center, (int)(this.radius - 1), (boolean)false, (int)this.height, (Material)this.material);
        WorldEditUtils.createCylinder((org.bukkit.World)player.getWorld(), (Location)center.clone().add(0.0, (double)(this.height - 1), 0.0), (int)(this.radius - 1), (boolean)true, (int)1, (Material)this.material);
        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> {
            for (BlockVector3 blockVector3 : gladiatorRegion) {
                Block block = world.getBlockAt(BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)blockVector3));
                if (block.getType().isAir()) continue;
                block.setMetadata(KitMetaData.GLADIATOR_BLOCK.getKey(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            }
        }, 5L);
        GladiatorFight gladiatorFight = new GladiatorFight(gladiatorRegion, kitPlayer, KitApi.getInstance().getPlayer(rightClicked), this.radius, this.height);
        kitPlayer.putKitAttribute(this.attributeKey, gladiatorFight);
        gladiatorFight.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
    }

    private Region getGladiatorLocation(Location location, int radius, int height) {
        Random random = new Random();
        CylinderRegion region = new CylinderRegion(BukkitAdapter.adapt((org.bukkit.World)location.getWorld()), BukkitAdapter.asBlockVector((Location)location), Vector2.at((double)radius, (double)radius), location.getBlockY(), location.getBlockY() + height);
        if (this.hasEnoughSpace((Region)region)) {
            return region;
        }
        return this.getGladiatorLocation(location.add(random.nextBoolean() ? -10.0 : 10.0, 5.0, random.nextBoolean() ? -10.0 : 10.0), radius, height);
    }

    private boolean hasEnoughSpace(Region region) {
        if (region.getWorld() == null) {
            return true;
        }
        org.bukkit.World world = BukkitAdapter.adapt((World)region.getWorld());
        for (BlockVector3 blockVector3 : region) {
            Location adapt = BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)blockVector3);
            if (!world.getWorldBorder().isInside(adapt)) {
                return false;
            }
            if (world.getBlockAt(adapt).getType().isAir()) continue;
            return false;
        }
        return true;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.hasMetadata(KitMetaData.GLADIATOR_BLOCK.getKey())) {
            this.changeGladiatorBlock((Cancellable)event, block);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        event.blockList().stream().filter(block -> block.hasMetadata(KitMetaData.GLADIATOR_BLOCK.getKey())).forEach(block -> this.changeGladiatorBlock((Cancellable)event, (Block)block));
    }

    private void changeGladiatorBlock(Cancellable event, Block block) {
        event.setCancelled(true);
        if (block.getType().equals((Object)this.material)) {
            block.setType(Material.GREEN_STAINED_GLASS);
        } else if (block.getType().equals((Object)Material.GREEN_STAINED_GLASS)) {
            block.setType(Material.YELLOW_STAINED_GLASS);
        } else if (block.getType().equals((Object)Material.YELLOW_STAINED_GLASS)) {
            block.setType(Material.RED_STAINED_GLASS);
        } else if (block.getType().equals((Object)Material.RED_STAINED_GLASS)) {
            event.setCancelled(false);
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    private class GladiatorFight
    extends BukkitRunnable {
        private final Region region;
        private final Player gladiator;
        private final Player enemy;
        private final KitPlayer gladiatorKitOwner;
        private final KitPlayer enemyKitOwner;
        private final org.bukkit.World world;
        private final Location oldLocationGladiator;
        private final Location oldLocationEnemy;
        private final int radius;
        private final int height;
        private final Location center;
        private int timer;

        public GladiatorFight(Region region, KitPlayer gladiator, KitPlayer enemy, int radius, int height) {
            this.region = region;
            this.gladiatorKitOwner = gladiator;
            this.enemyKitOwner = enemy;
            this.gladiator = Bukkit.getPlayer((UUID)gladiator.getUUID());
            this.enemy = Bukkit.getPlayer((UUID)enemy.getUUID());
            this.world = BukkitAdapter.adapt((World)region.getWorld());
            this.center = BukkitAdapter.adapt((org.bukkit.World)this.world, (Vector3)region.getCenter());
            this.oldLocationGladiator = this.gladiator.getLocation();
            this.oldLocationEnemy = this.enemy.getLocation();
            this.radius = radius;
            this.height = height;
            this.init();
        }

        public void init() {
            this.gladiatorKitOwner.getLastHitInformation().setLastPlayer(this.enemy);
            this.gladiatorKitOwner.getLastHitInformation().setPlayerTimeStamp(System.currentTimeMillis());
            this.enemyKitOwner.getLastHitInformation().setLastDamager(this.gladiator);
            this.enemyKitOwner.getLastHitInformation().setLastDamagerTimestamp(System.currentTimeMillis());
            this.gladiator.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 40, 20));
            this.enemy.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 40, 20));
            this.gladiator.teleport(new Location(this.world, this.center.getX() + (double)this.radius / 2.0, this.center.getY() + 1.0, this.center.getZ(), 90.0f, 0.0f));
            this.enemy.teleport(new Location(this.world, this.center.getX() - (double)this.radius / 2.0, this.center.getY() + 1.0, this.center.getZ(), -90.0f, 0.0f));
        }

        public void run() {
            if (!this.gladiator.isOnline() || !this.enemy.isOnline()) {
                this.endFight();
                return;
            }
            if (!this.gladiatorKitOwner.isValid() || !this.enemyKitOwner.isValid()) {
                this.endFight();
                return;
            }
            if (this.gladiator.getLocation().getY() < this.center.getY() || this.enemy.getLocation().getY() < this.center.getY()) {
                this.endFight();
                return;
            }
            if (this.region.contains(BukkitAdapter.asBlockVector((Location)this.gladiator.getLocation())) && this.region.contains(BukkitAdapter.asBlockVector((Location)this.enemy.getLocation()))) {
                ++this.timer;
                this.damageIntruders();
                if (this.timer > GladiatorKit.this.witherEffectAfterXSeconds) {
                    this.gladiator.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, Integer.MAX_VALUE, 2));
                    this.enemy.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, Integer.MAX_VALUE, 2));
                }
            } else {
                this.endFight();
            }
        }

        private void endFight() {
            this.gladiatorKitOwner.putKitAttribute(GladiatorKit.this.attributeKey, null);
            this.gladiator.removeMetadata(KitMetaData.INGLADIATOR.getKey(), (Plugin)KitApi.getInstance().getPlugin());
            this.enemy.removeMetadata(KitMetaData.INGLADIATOR.getKey(), (Plugin)KitApi.getInstance().getPlugin());
            this.gladiator.removePotionEffect(PotionEffectType.WITHER);
            this.enemy.removePotionEffect(PotionEffectType.WITHER);
            this.gladiator.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 40, 20));
            this.enemy.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 40, 20));
            if (this.gladiatorKitOwner.isValid()) {
                this.gladiator.teleport(this.oldLocationGladiator);
            }
            if (this.enemyKitOwner.isValid()) {
                this.enemy.teleport(this.oldLocationEnemy);
            }
            for (BlockVector3 blockVector3 : this.region) {
                Block block = this.world.getBlockAt(BukkitAdapter.adapt((org.bukkit.World)this.world, (BlockVector3)blockVector3));
                block.removeMetadata(KitMetaData.GLADIATOR_BLOCK.getKey(), (Plugin)KitApi.getInstance().getPlugin());
            }
            this.gladiatorKitOwner.activateKitCooldown(GladiatorKit.this);
            WorldEditUtils.createCylinder((org.bukkit.World)this.world, (Location)this.center, (int)this.radius, (boolean)true, (int)this.height, (Material)Material.AIR);
            this.cancel();
        }

        private void damageIntruders() {
            for (Player unknownPlayer : Bukkit.getOnlinePlayers()) {
                if (!unknownPlayer.getGameMode().equals((Object)GameMode.SURVIVAL) || unknownPlayer == this.gladiator || unknownPlayer == this.enemy || !this.region.contains(BukkitAdapter.asBlockVector((Location)unknownPlayer.getLocation()))) continue;
                unknownPlayer.damage(GladiatorKit.this.intruderDamage);
            }
        }
    }
}

