/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.ParticleArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.TimeConverter;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@BetaKit
public class GhostKit
extends AbstractKit
implements Listener {
    public static final GhostKit INSTANCE = new GhostKit();
    private static final String GHOST_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjhkMjE4MzY0MDIxOGFiMzMwYWM1NmQyYWFiN2UyOWE5NzkwYTU0NWY2OTE2MTllMzg1NzhlYTRhNjlhZTBiNiJ9fX0=";
    @FloatArg
    private final float cooldown;
    private final String isGhostModeKey;
    private final String ghostModeTaskKey;
    @IntArg
    private final int transformationParticleAmount;
    @IntArg
    private final int transformationParticleLoopAmount;
    @IntArg
    private final int trailParticleAmount;
    @IntArg
    private final int transformationInSeconds;
    @ParticleArg
    private final Particle particle;

    private GhostKit() {
        super("Ghost");
        ItemStack ghostHead = new KitItemBuilder(Material.PLAYER_HEAD).setPlayerSkullSkin(GHOST_HEAD).build();
        this.setDisplayItem(ghostHead);
        this.setMainKitItem(ghostHead);
        this.cooldown = 30.0f;
        this.isGhostModeKey = "isGhostMode" + this.getName();
        this.ghostModeTaskKey = "ghostMode" + this.getName();
        this.transformationParticleAmount = 30;
        this.transformationParticleLoopAmount = 15;
        this.trailParticleAmount = 5;
        this.transformationInSeconds = 5;
        this.particle = Particle.WHITE_ASH;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> player.setSilent(true));
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> player.setSilent(false));
        GhostMode task = (GhostMode)((Object)kitPlayer.getKitAttribute(this.ghostModeTaskKey));
        if (task != null) {
            task.end();
        }
    }

    @Override
    @KitEvent
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        this.doGhostTransformation(kitPlayer);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        this.doGhostTransformation(kitPlayer);
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onPlayerMoveEvent(PlayerMoveEvent event, KitPlayer kitPlayer) {
        if (kitPlayer.getKitAttributeOrDefault(this.isGhostModeKey, false).booleanValue()) {
            Player player = event.getPlayer();
            player.getWorld().spawnParticle(this.particle, player.getLocation(), this.trailParticleAmount);
        }
    }

    @EventHandler
    public void onPlayerStartSpectatingEntity(PlayerStartSpectatingEntityEvent event) {
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(event.getPlayer());
        if (kitPlayer.getKitAttributeOrDefault(this.isGhostModeKey, false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(event.getPlayer());
        if (!event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.SPECTATE)) {
            return;
        }
        if (kitPlayer.getKitAttributeOrDefault(this.isGhostModeKey, false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    private void doGhostTransformation(KitPlayer kitPlayer) {
        if (!kitPlayer.getKitAttributeOrDefault(this.isGhostModeKey, false).booleanValue()) {
            kitPlayer.getBukkitPlayer().ifPresent(player -> {
                GhostMode ghostMode = new GhostMode(kitPlayer, (Player)player);
                ghostMode.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
                kitPlayer.putKitAttribute(this.ghostModeTaskKey, ghostMode);
            });
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    private class GhostMode
    extends BukkitRunnable {
        private final KitPlayer kitPlayer;
        private final Player player;
        private int counter;

        private GhostMode(KitPlayer kitPlayer, Player player) {
            this.kitPlayer = kitPlayer;
            this.player = player;
            this.init();
        }

        private void init() {
            for (int i = 0; i < GhostKit.this.transformationParticleLoopAmount; ++i) {
                this.player.getWorld().spawnParticle(GhostKit.this.particle, this.player.getLocation(), GhostKit.this.transformationParticleAmount);
            }
            this.player.setGameMode(GameMode.SPECTATOR);
            this.kitPlayer.putKitAttribute(GhostKit.this.isGhostModeKey, true);
            this.player.sendMessage(ChatColor.GREEN + "Ghost-Mode wurde aktiviert!");
        }

        public void run() {
            int timeLeft = GhostKit.this.transformationInSeconds - this.counter;
            if (this.counter >= GhostKit.this.transformationInSeconds || !this.kitPlayer.isValid()) {
                this.end();
                return;
            }
            this.player.sendActionBar("Ghost-Mode endet in: " + TimeConverter.stringify((int)timeLeft));
            ++this.counter;
        }

        public void end() {
            this.cancel();
            if (this.player.getGameMode() == GameMode.SPECTATOR) {
                this.player.setGameMode(GameMode.SURVIVAL);
            }
            this.player.sendMessage(ChatColor.RED + "Ghost-Mode wurde deaktiviert!");
            this.kitPlayer.putKitAttribute(GhostKit.this.isGhostModeKey, false);
            this.kitPlayer.putKitAttribute(GhostKit.this.ghostModeTaskKey, null);
            this.kitPlayer.activateKitCooldown(GhostKit.this);
        }
    }
}

