/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.CircleUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class GardenerKit
extends AbstractKit
implements Listener {
    public static final GardenerKit INSTANCE = new GardenerKit();
    private final List<Material> destructibleBlocks = Arrays.asList(Material.AIR, Material.GRASS, Material.TALL_GRASS, Material.SNOW, Material.DEAD_BUSH);
    @IntArg
    private final int radius;
    @IntArg
    private final int heightRadius;
    private final String blockListKey;
    private final String gardenerBushKey;
    private final List<Material> ackerMaterials = Arrays.asList(Material.GRASS_BLOCK, Material.DIRT, Material.FARMLAND);

    private GardenerKit() {
        super("Gardener", Material.SWEET_BERRIES);
        this.radius = 5;
        this.heightRadius = 3;
        this.blockListKey = this.getName() + "blockListKey";
        this.gardenerBushKey = this.getName() + "gardenerBushKey";
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        Set blocks = kitPlayer.getKitAttributeOrDefault(this.blockListKey, new HashSet());
        for (Block block : blocks) {
            if (!block.getType().equals((Object)Material.SWEET_BERRY_BUSH)) continue;
            block.removeMetadata(this.gardenerBushKey, (Plugin)KitApi.getInstance().getPlugin());
            block.setType(Material.AIR);
        }
        blocks.clear();
    }

    @Override
    @KitEvent
    public void onPlayerIsSneakingEvent(PlayerToggleSneakEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        HashSet<Block> blocks = new HashSet<Block>();
        for (int i = -this.heightRadius; i < this.heightRadius; ++i) {
            HashSet locations = CircleUtils.makeCircle((Location)player.getLocation(), (Integer)this.radius, (Integer)1, (Boolean)false, (Boolean)false, (int)i);
            for (Location location : locations) {
                Block block = location.getBlock();
                if (!this.destructibleBlocks.contains(block.getType()) || !this.ackerMaterials.contains(block.getRelative(BlockFace.DOWN).getType())) continue;
                block.setType(Material.SWEET_BERRY_BUSH);
                if (block.getBlockData() instanceof Ageable) {
                    Ageable ageable = (Ageable)block.getBlockData();
                    ageable.setAge(2);
                    block.setBlockData((BlockData)ageable);
                }
                block.setMetadata(this.gardenerBushKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
                blocks.add(block);
            }
        }
        kitPlayer.putKitAttribute(this.blockListKey, blocks);
    }

    @Override
    @KitEvent
    public void onPlayerIsNotSneakingAnymoreEvent(PlayerToggleSneakEvent event, KitPlayer kitPlayer) {
        this.onDeactivation(kitPlayer);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.hasMetadata(this.gardenerBushKey)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(EntityDamageByBlockEvent event) {
        Block block = event.getDamager();
        if (block == null) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            KitPlayer player = KitApi.getInstance().getPlayer((Player)event.getEntity());
            if (!player.hasKit(this)) {
                return;
            }
            if (block.hasMetadata(this.gardenerBushKey)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock.hasMetadata(this.gardenerBushKey)) {
            event.setCancelled(true);
        }
    }

    public String getGardenerBushKey() {
        return this.gardenerBushKey;
    }
}

