/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.BukkitUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;

@BetaKit
public class FahrradKit
extends AbstractKit
implements Listener {
    public static final FahrradKit INSTANCE = new FahrradKit();
    @DoubleArg
    private final double divideBy;
    @FloatArg
    private final float cooldown;
    private final Map<UUID, Double> defaultMovementSpeed;
    private final String fahrradOwner;
    private final String fahrradId;

    private FahrradKit() {
        super("Fahrrad", Material.SADDLE);
        this.setMainKitItem(Material.BELL);
        this.divideBy = 18.0;
        this.defaultMovementSpeed = new HashMap<UUID, Double>();
        this.fahrradOwner = "fahrradOwner" + this.getName();
        this.fahrradId = "fahrradId" + this.getName();
        this.cooldown = 90.0f;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        UUID uuid = (UUID)kitPlayer.getKitAttribute(this.fahrradId);
        if (uuid != null) {
            Optional.ofNullable(Bukkit.getEntity((UUID)uuid)).ifPresent(Entity::remove);
        }
    }

    @Override
    @KitEvent
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (player.isInsideVehicle()) {
            player.sendMessage(ChatColor.RED + "Du befindest dich bereits in einem Fahrzeug");
            return;
        }
        BukkitUtils.playSound(player, Sound.BLOCK_CHAIN_PLACE);
        Horse horse = (Horse)player.getWorld().spawn(player.getLocation(), Horse.class);
        horse.setOwner((AnimalTamer)player);
        horse.getInventory().setSaddle(new ItemStack(Material.SADDLE));
        horse.setCustomName("Fahrrad von " + player.getName());
        horse.setCustomNameVisible(true);
        horse.setMetadata(this.fahrradOwner, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)player.getUniqueId()));
        kitPlayer.putKitAttribute(this.fahrradId, horse.getUniqueId());
        horse.addPassenger((Entity)player);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> {
            if (player.isInsideVehicle()) {
                player.playSound(player.getLocation(), Sound.BLOCK_BELL_USE, 1.0f, 1.0f);
            }
        });
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getDismounted();
        if (entity.hasMetadata(this.fahrradOwner)) {
            UUID uuid = (UUID)((MetadataValue)entity.getMetadata(this.fahrradOwner).get(0)).value();
            entity.remove();
            KitApi.getInstance().getPlayerSupplier().getKitPlayer(uuid).activateKitCooldown(this);
        }
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onPlayerMoveEvent(PlayerMoveEvent event, KitPlayer kitPlayer) {
        this.handleRidingEntity(event.getPlayer().getVehicle(), kitPlayer);
    }

    private void handleRidingEntity(Entity vehicle, KitPlayer kitPlayer) {
        if (vehicle instanceof Player) {
            return;
        }
        if (!(vehicle instanceof LivingEntity)) {
            return;
        }
        AttributeInstance attribute = ((LivingEntity)vehicle).getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (attribute != null) {
            if (!this.defaultMovementSpeed.containsKey(vehicle.getUniqueId())) {
                this.defaultMovementSpeed.put(vehicle.getUniqueId(), attribute.getValue());
            }
            double defaultMovement = this.defaultMovementSpeed.get(vehicle.getUniqueId());
            double max = Math.max(defaultMovement, defaultMovement + (double)kitPlayer.getLeftCps() / this.divideBy);
            kitPlayer.getBukkitPlayer().ifPresent(player -> player.sendActionBar(String.format("%.2f", max) + " km/h | (" + kitPlayer.getLeftCps() + " CPS)"));
            attribute.setBaseValue(max);
        }
    }
}

