/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.BukkitUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

@BetaKit
public class ElytraKit
extends AbstractKit {
    public static final ElytraKit INSTANCE = new ElytraKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @FloatArg(min=0.0f)
    private final float normalBoost;
    @FloatArg(min=0.0f)
    private final float combatBoost;
    @IntArg
    private final int glidingDelay;

    private ElytraKit() {
        super("Elytra", Material.FEATHER);
        this.setMainKitItem(this.getDisplayMaterial());
        this.cooldown = 45.0f;
        this.normalBoost = 2.5f;
        this.combatBoost = 1.0f;
        this.glidingDelay = 5;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (player.isInsideVehicle()) {
            return;
        }
        if (kitPlayer.isInCombat()) {
            player.setVelocity(player.getVelocity().setY(this.combatBoost));
            player.sendActionBar(ChatColor.RED + "Elytra kann im Kampf nicht eingesetzt werden");
        } else {
            player.setVelocity(player.getVelocity().setY(this.normalBoost));
        }
        BukkitUtils.runTaskLater(() -> player.setGliding(true), this.glidingDelay);
        kitPlayer.activateKitCooldown(this);
    }

    @EventHandler
    public void onEntityToggleGlideEvent(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!kitPlayer.hasKit(this)) {
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (chestplate != null && chestplate.getType().equals((Object)Material.ELYTRA)) {
            return;
        }
        if (!player.isOnGround()) {
            event.setCancelled(true);
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

