/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.SoundArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DiggerKit
extends AbstractKit {
    public static final DiggerKit INSTANCE = new DiggerKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private final int radius;
    @FloatArg(min=0.0f, max=15.0f)
    private final float volume;
    @SoundArg
    private final Sound sound = Sound.BLOCK_STONE_BREAK;

    private DiggerKit() {
        super("Digger", Material.DRAGON_EGG);
        this.cooldown = 12.0f;
        this.radius = 6;
        this.volume = 1.8f;
        this.setMainKitItem(this.getDisplayMaterial(), 16);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Block clickedBlock = event.getClickedBlock();
        final Player player = event.getPlayer();
        if (clickedBlock != null) {
            if (player.getInventory().getItemInMainHand().isSimilar(this.mainKitItem)) {
                player.getInventory().getItemInMainHand().subtract();
            } else if (player.getInventory().getItemInOffHand().isSimilar(this.mainKitItem)) {
                player.getInventory().getItemInOffHand().subtract();
            }
            final Block block = clickedBlock.getLocation().add(0.0, 1.0, 0.0).getBlock();
            kitPlayer.activateKitCooldown(this);
            new BukkitRunnable(){

                public void run() {
                    int dist = (int)Math.ceil((double)(DiggerKit.this.radius - 1) / 2.0);
                    for (int y = -1; y >= -DiggerKit.this.radius; --y) {
                        for (int x = -dist; x <= dist; ++x) {
                            for (int z = -dist; z <= dist; ++z) {
                                Block b;
                                if (block.getY() + y <= 0 || (b = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z)).hasMetadata("feastBlock") || b.hasMetadata(KitMetaData.GLADIATOR_BLOCK.getKey()) || b.getType().equals((Object)Material.BEDROCK)) continue;
                                if (b instanceof Container) {
                                    b.breakNaturally();
                                    continue;
                                }
                                b.setType(Material.AIR);
                            }
                        }
                    }
                    player.getWorld().playSound(player.getLocation(), DiggerKit.this.sound, DiggerKit.this.volume, 1.0f);
                }
            }.runTaskLater((Plugin)KitApi.getInstance().getPlugin(), 15L);
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

