/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ChanceUtils;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class DannyKit
extends AbstractKit {
    public static final DannyKit INSTANCE = new DannyKit();
    private final PotionEffectType[] potionEffects = new PotionEffectType[]{PotionEffectType.BLINDNESS, PotionEffectType.WITHER, PotionEffectType.POISON, PotionEffectType.WEAKNESS, PotionEffectType.HARM, PotionEffectType.CONFUSION};
    private final String attributeKey = this.getName() + "Runnable";
    @IntArg(min=0, max=100)
    private final int dannyHeadLikelihood;
    @IntArg
    private final int potionDuration;
    @IntArg
    private final int potionAmplifier;

    private DannyKit() {
        super("Danny", Material.PLAYER_HEAD);
        this.dannyHeadLikelihood = 22;
        this.potionDuration = 3;
        this.potionAmplifier = 1;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), () -> {
            if (kitPlayer.isValid()) {
                DannyAction action = DannyAction.values()[new Random().nextInt(DannyAction.values().length)];
                Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
                if (player == null) {
                    return;
                }
                switch (action) {
                    case EAT_ITEM: {
                        player.playSound(player.getLocation(), Sound.ENTITY_DONKEY_EAT, 10.0f, 1.0f);
                        player.getInventory().setItem(new Random().nextInt(player.getInventory().getSize()), new ItemStack(Material.AIR));
                        break;
                    }
                    case NEGATIVE_EFFECT: {
                        player.playSound(player.getLocation(), Sound.ENTITY_DONKEY_HURT, 10.0f, 1.0f);
                        PotionEffect effect = new PotionEffect(this.potionEffects[new Random().nextInt(this.potionEffects.length)], this.potionDuration * 20, this.potionAmplifier);
                        player.addPotionEffect(effect);
                        break;
                    }
                    case SKULL_ESCALATION: {
                        player.playSound(player.getLocation(), Sound.ENTITY_DONKEY_AMBIENT, 10.0f, 1.0f);
                        ItemStack stack = new ItemStack(Material.PLAYER_HEAD, new Random().nextInt(12));
                        SkullMeta meta = (SkullMeta)stack.getItemMeta();
                        meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)"Daannyy"));
                        stack.setItemMeta((ItemMeta)meta);
                        for (int i = 0; i < new Random().nextInt(6); ++i) {
                            player.getWorld().dropItemNaturally(player.getLocation(), stack);
                        }
                        break;
                    }
                    case DROP_ITEM: {
                        player.playSound(player.getLocation(), Sound.ENTITY_DONKEY_DEATH, 10.0f, 1.0f);
                        if (player.getItemInHand().getType() == Material.AIR) break;
                        player.dropItem(false);
                    }
                }
            }
        }, 0L, 200L);
        kitPlayer.putKitAttribute(this.attributeKey, task);
    }

    @Override
    @KitEvent
    public void onCraftItem(CraftItemEvent event) {
        if (ChanceUtils.roll((int)this.dannyHeadLikelihood)) {
            ItemStack stack = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)stack.getItemMeta();
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)"Daannyy"));
            stack.setItemMeta((ItemMeta)meta);
            event.setCurrentItem(stack);
        }
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        BukkitTask task = (BukkitTask)kitPlayer.getKitAttribute(this.attributeKey);
        if (task != null) {
            task.cancel();
        }
    }

    public static enum DannyAction {
        EAT_ITEM,
        NEGATIVE_EFFECT,
        SKULL_ESCALATION,
        DROP_ITEM;

    }
}

