/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.kits.SurpriseKit;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;

public class CopyCatKit
extends AbstractKit {
    public static final CopyCatKit INSTANCE = new CopyCatKit();
    private final String copiedKitKey = this.getName() + "copiedKit";

    private CopyCatKit() {
        super("CopyCat", Material.CAT_SPAWN_EGG);
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        AbstractKit copiedKit = (AbstractKit)kitPlayer.getKitAttribute(this.copiedKitKey);
        if (copiedKit != null && copiedKit != this) {
            copiedKit.onDeactivation(kitPlayer);
        }
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        AbstractKit copiedKit = (AbstractKit)kitPlayer.getKitAttribute(this.copiedKitKey);
        if (copiedKit != null) {
            if (copiedKit.equals(this)) {
                AbstractKit randomKit = SurpriseKit.INSTANCE.getRandomEnabledKit();
                kitPlayer.putKitAttribute(this.copiedKitKey, randomKit);
                randomKit.onEnable(kitPlayer);
            } else {
                copiedKit.onEnable(kitPlayer);
            }
        }
    }

    @Override
    @KitEvent(clazz=PlayerDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        AbstractKit oldCopiedKit = (AbstractKit)killer.getKitAttribute(this.copiedKitKey);
        AbstractKit newKit = dead.getKits().get(0);
        if (oldCopiedKit != null) {
            oldCopiedKit.onDeactivation(killer);
            Optional.ofNullable(Bukkit.getPlayer((UUID)killer.getUUID())).ifPresent(player -> KitApi.getInstance().removeKitItems(oldCopiedKit, (Player)player));
        }
        killer.putKitAttribute(this.copiedKitKey, newKit);
        KitApi.getInstance().giveKitItemsIfInvFull(killer, newKit);
        newKit.onEnable(killer);
    }

    public String getKitAttributeKey() {
        return this.copiedKitKey;
    }
}

