/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.EntityArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionEffectArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ClawKit
extends AbstractKit
implements Listener {
    public static final ClawKit INSTANCE = new ClawKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private final int radius;
    @IntArg
    private final int potionDuration;
    @IntArg
    private final int potionMultiplier;
    @EntityArg
    private final EntityType entityType;
    @PotionEffectArg
    private final PotionEffectType potionType;

    private ClawKit() {
        super("Claw", Material.SHEARS);
        this.cooldown = 12.0f;
        this.setMainKitItem(this.getDisplayMaterial(), true);
        this.radius = 15;
        this.entityType = EntityType.EVOKER_FANGS;
        this.potionType = PotionEffectType.SLOW;
        this.potionDuration = 5;
        this.potionMultiplier = 10;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        KitPlayer hgPlayer = KitApi.getInstance().getPlayer(player);
        Location start = player.getLocation();
        Location start2 = player.getLocation().add(0.0, 2.0, 0.0);
        Vector direction = start.getDirection();
        for (int i = 1; i <= this.radius; ++i) {
            player.getWorld().spawnEntity(start.clone().add(direction.clone().multiply(i)), this.entityType).setMetadata(player.getUniqueId().toString(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            player.getWorld().spawnEntity(start2.clone().add(direction.clone().multiply(i)), this.entityType).setMetadata(player.getUniqueId().toString(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
        }
        hgPlayer.activateKitCooldown(this);
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (event.getEntity() instanceof Player && damager.getType().equals((Object)this.entityType)) {
            Player player = (Player)event.getEntity();
            KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
            if (kitPlayer.isValid()) {
                if (damager.hasMetadata(player.getUniqueId().toString())) {
                    event.setCancelled(true);
                } else {
                    player.addPotionEffect(new PotionEffect(this.potionType, 20 * this.potionDuration, this.potionMultiplier));
                }
            }
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

