/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.Utils;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.InventoryBuilder;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ChameleonKit
extends AbstractKit {
    public static final ChameleonKit INSTANCE = new ChameleonKit();
    private final String catchedMobKey = "catchedMobs";
    private final NamespacedKey BINDED_MOB_KEY = new NamespacedKey((Plugin)KitApi.getInstance().getPlugin(), "binded_mob");
    @IntArg
    private int maxAnimals;

    protected ChameleonKit() {
        super("Chameleon", Material.DIRT_PATH);
        this.setMainKitItem(this.getDisplayMaterial());
        this.maxAnimals = 9;
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        Optional<Player> bukkitPlayer = kitPlayer.getBukkitPlayer();
        bukkitPlayer.ifPresent(player -> {
            DisguiseAPI.undisguiseToAll((Entity)player);
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        });
    }

    @Override
    @KitEvent
    public void onPlayerGetsAttackedByLivingEntity(EntityDamageByEntityEvent event, Player player, LivingEntity attacker) {
        if (attacker instanceof Player) {
            DisguiseAPI.undisguiseToAll((Entity)player);
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        InventoryBuilder builder = new InventoryBuilder((Plugin)KitApi.getInstance().getPlugin());
        builder.withName(Localization.INSTANCE.getMessage("chameleon.inventoryName", ChatUtils.locale((Player)player)));
        builder.withSlots(Utils.translateGuiScale(this.maxAnimals));
        int slot = -1;
        if (KitApi.getInstance().getPlayer(player).getKitAttribute("catchedMobs") != null) {
            for (EntityType caughtEntity : (List)KitApi.getInstance().getPlayer(player).getKitAttribute("catchedMobs")) {
                Material material;
                ++slot;
                try {
                    material = Material.valueOf((String)(caughtEntity.name() + "_SPAWN_EGG"));
                }
                catch (Exception e) {
                    material = Material.SPAWNER;
                }
                ItemStack itemStack = new ItemBuilder(material).setName(caughtEntity.name().replace("_", " ")).setDescription(new String[]{"", ChatColor.DARK_AQUA.toString() + ChatColor.ITALIC + Localization.INSTANCE.getMessage("chameleon.tooltip", ChatUtils.locale((Player)player))}).build();
                ItemMeta meta = itemStack.getItemMeta();
                meta.getPersistentDataContainer().set(this.BINDED_MOB_KEY, PersistentDataType.STRING, (Object)caughtEntity.name());
                itemStack.setItemMeta(meta);
                builder.withItem(itemStack, slot, onClick -> {
                    PersistentDataContainer dataContainer;
                    Player clickedPlayer = (Player)onClick.getWhoClicked();
                    clickedPlayer.closeInventory();
                    KitPlayer clickedKitPlayer = KitApi.getInstance().getPlayer(clickedPlayer);
                    if (!clickedKitPlayer.areKitsDisabled() && clickedKitPlayer.isValid() && onClick.getCurrentItem().hasItemMeta() && (dataContainer = onClick.getCurrentItem().getItemMeta().getPersistentDataContainer()).has(this.BINDED_MOB_KEY, PersistentDataType.STRING)) {
                        EntityType entityType = EntityType.valueOf((String)((String)dataContainer.get(this.BINDED_MOB_KEY, PersistentDataType.STRING)));
                        clickedPlayer.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 255, false, false));
                        DisguiseAPI.disguiseEntity((Entity)clickedPlayer, (Disguise)new MobDisguise(DisguiseType.getType((EntityType)entityType)));
                        if (DisguiseAPI.getDisguise((Entity)clickedPlayer).getEntity() instanceof LivingEntity) {
                            ((LivingEntity)DisguiseAPI.getDisguise((Entity)clickedPlayer).getEntity()).removePotionEffect(PotionEffectType.INVISIBILITY);
                        }
                    }
                });
            }
        }
        player.openInventory(builder.build());
    }

    @Override
    @KitEvent
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        DisguiseAPI.undisguiseToAll((Entity)event.getPlayer());
        event.getPlayer().removePotionEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    @KitEvent
    public void onHitLivingEntityWithKitItem(EntityDamageByEntityEvent event, KitPlayer attacker, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            if (attacker.getKitAttribute("catchedMobs") == null) {
                attacker.putKitAttribute("catchedMobs", new ArrayList<EntityType>(Collections.singletonList(entity.getType())));
            } else {
                ArrayList catchedMobs = (ArrayList)attacker.getKitAttribute("catchedMobs");
                if (catchedMobs.size() == this.maxAnimals) {
                    attacker.getBukkitPlayer().ifPresent(player -> player.sendMessage(Localization.INSTANCE.getMessage("chameleon.reachedAnimalLimit", ChatUtils.locale((Player)player))));
                } else {
                    if (!catchedMobs.contains(entity.getType())) {
                        catchedMobs.add(entity.getType());
                        attacker.putKitAttribute("catchedMobs", catchedMobs);
                    }
                    attacker.getBukkitPlayer().ifPresent(player -> {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 255, false, false));
                        DisguiseAPI.disguiseEntity((Entity)player, (Disguise)new MobDisguise(DisguiseType.getType((EntityType)entity.getType())));
                        if (DisguiseAPI.getDisguise((Entity)player).getEntity() instanceof LivingEntity) {
                            ((LivingEntity)DisguiseAPI.getDisguise((Entity)player).getEntity()).removePotionEffect(PotionEffectType.INVISIBILITY);
                        }
                    });
                }
            }
        }
    }
}

