/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftBee;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BeequeenKit
extends AbstractKit
implements Listener {
    public static final BeequeenKit INSTANCE = new BeequeenKit();
    @IntArg
    private final int honeyDurationInSeconds;
    @IntArg
    private final int movementTick;
    @IntArg
    private final int beeAmount;
    @FloatArg(min=0.0f)
    private final float cooldown;
    private final String honeyTrailKey;
    private final String isHoneyBlockKey;

    private BeequeenKit() {
        super("Beequeen", Material.HONEY_BLOCK);
        this.mainKitItem = new KitItemBuilder(Material.HONEYCOMB).build();
        this.honeyDurationInSeconds = 7;
        this.cooldown = 35.0f;
        this.movementTick = 1;
        this.beeAmount = 3;
        this.honeyTrailKey = this.getName() + "honeyTrailKey";
        this.isHoneyBlockKey = this.getName() + "honeyBlockKey";
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        HoneyTrail honeyTrail = (HoneyTrail)((Object)kitPlayer.getKitAttribute(this.honeyTrailKey));
        if (honeyTrail != null) {
            honeyTrail.stop();
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().hasMetadata(this.isHoneyBlockKey)) {
            event.setCancelled(true);
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickPlayerWithKitItem(PlayerInteractAtEntityEvent event, KitPlayer kitPlayer, Player rightClicked) {
        kitPlayer.activateKitCooldown(this);
        HoneyTrail honeyTrail = new HoneyTrail(rightClicked);
        honeyTrail.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, this.movementTick);
        kitPlayer.putKitAttribute(this.honeyTrailKey, honeyTrail);
    }

    public String getIsHoneyBlockKey() {
        return this.isHoneyBlockKey;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    private final class HoneyTrail
    extends BukkitRunnable {
        private final Player player;
        private final KitPlayer kitPlayer;
        private final BlockFace[] directions;
        private final long endTime;
        private final Map<BlockFace, Block> currentHoneyBlocks;
        private final Map<BlockFace, BlockData> oldFaceBlockData;
        private final Map<Block, BlockData> oldBlockData;
        private final List<Bee> bees;

        private HoneyTrail(Player player) {
            this.player = player;
            this.oldBlockData = new HashMap<Block, BlockData>();
            this.kitPlayer = KitApi.getInstance().getPlayer(player);
            this.endTime = System.currentTimeMillis() + (long)BeequeenKit.this.honeyDurationInSeconds * 1000L;
            this.directions = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.SELF, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_WEST, BlockFace.SOUTH_EAST};
            this.bees = new ArrayList<Bee>();
            this.currentHoneyBlocks = new HashMap<BlockFace, Block>();
            this.oldFaceBlockData = new HashMap<BlockFace, BlockData>();
            for (int i = 0; i < BeequeenKit.this.beeAmount; ++i) {
                Bee bee = (Bee)player.getWorld().spawnEntity(player.getEyeLocation(), EntityType.BEE);
                this.bees.add(bee);
            }
            this.makeBeesAngry();
        }

        public void run() {
            if (this.player.isDead() || !this.kitPlayer.isValid()) {
                this.stop();
                return;
            }
            if (System.currentTimeMillis() > this.endTime) {
                this.stop();
                return;
            }
            this.makeBeesAngry();
            Block block = this.player.getLocation().getBlock().getRelative(BlockFace.DOWN);
            if (this.player.getLocation().getBlock().getType().equals((Object)Material.HONEY_BLOCK)) {
                return;
            }
            for (BlockFace direction : this.directions) {
                Block relative = block.getRelative(direction);
                if (!relative.getType().isSolid() || relative.getType().equals((Object)Material.HONEY_BLOCK) || Utils.isUnbreakableLaborBlock(relative)) continue;
                if (this.currentHoneyBlocks.containsKey(direction)) {
                    Block toReplace = this.currentHoneyBlocks.get(direction);
                    BlockData blockData = this.oldFaceBlockData.getOrDefault(direction, Material.DIAMOND_BLOCK.createBlockData());
                    if (blockData != null) {
                        toReplace.setBlockData(blockData);
                        toReplace.removeMetadata(BeequeenKit.this.isHoneyBlockKey, (Plugin)KitApi.getInstance().getPlugin());
                        this.oldBlockData.remove(toReplace);
                    }
                }
                BlockData clone = relative.getBlockData().clone();
                this.oldBlockData.put(relative, clone);
                relative.setMetadata(BeequeenKit.this.isHoneyBlockKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
                relative.setType(Material.HONEY_BLOCK);
                this.currentHoneyBlocks.put(direction, relative);
                this.oldFaceBlockData.put(direction, clone);
            }
        }

        private void makeBeesAngry() {
            for (Bee bee : this.bees) {
                bee.setAnger(5);
                bee.setTarget((LivingEntity)this.player);
                ((CraftBee)bee).getHandle().setAngerTarget(this.player.getUniqueId());
            }
        }

        private void stop() {
            this.cancel();
            this.oldBlockData.keySet().forEach(block -> {
                block.setBlockData(this.oldBlockData.get(block));
                block.removeMetadata(BeequeenKit.this.isHoneyBlockKey, (Plugin)KitApi.getInstance().getPlugin());
            });
            this.bees.forEach(Entity::remove);
        }
    }
}

