/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.items;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.supplier.KitPlayerSupplier;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class KitItemHandler
implements Listener {
    protected final KitPlayerSupplier playerSupplier = KitApi.getInstance().getPlayerSupplier();

    @EventHandler
    public void disableHandSwapForOffHandKits(PlayerSwapHandItemsEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        for (AbstractKit kit : kitPlayer.getKits()) {
            if (!kit.isUsingOffHand()) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void disableOffHandInventoryClick(InventoryClickEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getWhoClicked());
        if (event.getRawSlot() != 45) {
            return;
        }
        for (AbstractKit kit : kitPlayer.getKits()) {
            if (!kit.isUsingOffHand()) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            return;
        }
        if (event.getItem() == null) {
            return;
        }
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        for (AbstractKit kit : kitPlayer.getKits()) {
            if (kit.isKitItemPlaceable() || !kit.isKitItem(event.getItem())) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void cancelKitItemPlace(BlockPlaceEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        for (AbstractKit kit : kitPlayer.getKits()) {
            if (kit.isKitItemPlaceable() || !kit.isKitItem(event.getItemInHand())) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void cancelKitItemDrop(PlayerDropItemEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        for (AbstractKit kit : kitPlayer.getKits()) {
            if (!kit.isKitItem(droppedItem)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || !clickedInventory.getType().equals((Object)InventoryType.GRINDSTONE)) {
            return;
        }
        if (event.getSlot() != 2) {
            return;
        }
        for (int i = 0; i <= 1; ++i) {
            ItemStack item = clickedInventory.getItem(i);
            if (item == null || !item.hasItemMeta() || !KitApi.getInstance().getAllKits().stream().anyMatch(kit -> kit.isKitItem(item))) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        for (ItemStack ingridient : event.getInventory().getMatrix()) {
            if (ingridient == null || !ingridient.hasItemMeta() || !KitApi.getInstance().getAllKits().stream().anyMatch(kit -> kit.isKitItem(ingridient))) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void avoidKitItemDropOnPlayerDeath(ItemSpawnEvent event) {
        ItemStack itemStack = event.getEntity().getItemStack();
        for (AbstractKit kit : KitApi.getInstance().getEnabledKits()) {
            if (!kit.isKitItem(itemStack)) continue;
            itemStack.setType(Material.AIR);
            itemStack.setAmount(0);
            event.getEntity().remove();
        }
    }
}

