/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.events;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.MultipleKitItemsKit;
import de.hglabor.plugins.kitapi.kit.events.KitEventHandler;
import de.hglabor.plugins.kitapi.kit.events.KitExecutor;
import de.hglabor.plugins.kitapi.kit.events.event.PlayerAteSoupEvent;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import io.papermc.paper.event.entity.EntityMoveEvent;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;

public class KitEventHandlerImpl
extends KitEventHandler
implements Listener {
    public KitEventHandlerImpl() {
        super(KitApi.getInstance().getPlayerSupplier());
    }

    @EventHandler
    public void onPlayerAttacksLivingEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof LivingEntity) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getDamager());
            this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerAttacksLivingEntity(event, kitPlayer, (LivingEntity)event.getEntity()));
        }
    }

    @EventHandler
    public void onPlayerGetsAttackedByLivingEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof LivingEntity && event.getEntity() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getEntity());
            if (event.getDamager() instanceof Player && !this.playerSupplier.getKitPlayer((Player)event.getDamager()).isValid()) {
                return;
            }
            this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerGetsAttackedByLivingEntity(event, (Player)event.getEntity(), (LivingEntity)event.getDamager()));
        }
    }

    @EventHandler
    public void onToggleSneakEvent(PlayerToggleSneakEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        if (event.isSneaking()) {
            this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerIsSneakingEvent(event, kitPlayer));
        } else {
            this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerIsNotSneakingAnymoreEvent(event, kitPlayer));
        }
    }

    @Override
    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getWhoClicked());
        this.useKit((Event)event, kitPlayer, kit -> kit.onCraftItem(event));
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        this.useKit((Event)event, kitPlayer, kit -> kit.onDropItem(event, kitPlayer));
    }

    @Override
    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getEntity());
            this.useKit((Event)event, kitPlayer, kit -> kit.onEntityDamage(event));
        }
    }

    @Override
    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getEntity());
            this.useKit((Event)event, kitPlayer, kit -> kit.onEntityDeath(event));
        }
    }

    @EventHandler
    public void onPlayerRightClickPlayerWithKitItem(PlayerInteractAtEntityEvent event) {
        Entity rightClicked = event.getRightClicked();
        if (rightClicked instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerRightClickPlayerWithKitItem(event, kitPlayer, (Player)rightClicked));
        } else if (rightClicked instanceof LivingEntity) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerRightClickLivingEntityWithKitItem(event, kitPlayer, (LivingEntity)rightClicked));
        }
    }

    @EventHandler
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getDamager());
        if (event.getEntity() instanceof LivingEntity) {
            for (AbstractKit playerKit : kitPlayer.getKits()) {
                if (!((Player)event.getDamager()).getInventory().getItemInMainHand().isSimilar(playerKit.getMainKitItem())) continue;
                this.useKitItem((Event)event, kitPlayer, kit -> kit.onHitLivingEntityWithKitItem(event, kitPlayer, (LivingEntity)event.getEntity()));
            }
        } else {
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onHitEntityWithKitItem(event, kitPlayer, event.getEntity()));
        }
    }

    @EventHandler
    public void onPlayerKillsLivingEntity(EntityDeathEvent event) {
        if (event.getEntity().getKiller() != null) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getEntity().getKiller());
            this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerKillsLivingEntity(event, event.getEntity().getKiller(), (Entity)event.getEntity()));
        }
    }

    @Override
    @EventHandler
    public void onKitPlayerDeath(PlayerDeathEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getEntity());
        this.useKit((Event)event, kitPlayer, kit -> kit.onKitPlayerDeath(event));
    }

    @Override
    @EventHandler
    public void onBlockBreakWithKitItem(BlockBreakEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        this.useKitItem((Event)event, kitPlayer, kit -> kit.onBlockBreakWithKitItem(event));
    }

    @Override
    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getEntity().getShooter());
            this.useKit((Event)event, kitPlayer, kit -> kit.onProjectileLaunch(event));
        }
    }

    @EventHandler
    public void onPlayerAteSoupEvent(PlayerAteSoupEvent event) {
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerAteSoupEvent(event, kitPlayer));
    }

    @EventHandler
    public void onPlayerKillsPlayer(PlayerDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        if (killer != null) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(killer);
            this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerKillsPlayer(KitApi.getInstance().getPlayer(killer), KitApi.getInstance().getPlayer(event.getEntity())));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getTo().distanceSquared(event.getFrom()) == 0.0) {
            return;
        }
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        this.useKit((Event)event, kitPlayer, kit -> kit.onPlayerMoveEvent(event, kitPlayer));
    }

    @Override
    @EventHandler
    public void onEntityResurrect(EntityResurrectEvent event) {
        if (event.getEntity() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getEntity());
            this.useKit((Event)event, kitPlayer, kit -> kit.onEntityResurrect(event));
        }
    }

    @EventHandler
    public void onPlayerRightClickKitItem(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
            ItemStack kitItem = event.getItem() != null ? event.getItem() : new ItemStack(Material.AIR);
            this.useOneOfMultipleKitItems((Event)event, kitPlayer, kitItem, kit -> kit.onPlayerRightClicksOneOfMultipleKitItems(event, kitPlayer, kitItem));
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerRightClickKitItem(event, kitPlayer));
        }
    }

    @EventHandler
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.LEFT_CLICK_AIR) || event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
            ItemStack kitItem = event.getItem() != null ? event.getItem() : new ItemStack(Material.AIR);
            this.useOneOfMultipleKitItems((Event)event, kitPlayer, kitItem, kit -> kit.onPlayerLeftClicksOneOfMultipleKitItems(event, kitPlayer, kitItem));
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerLeftClickKitItem(event, kitPlayer));
        }
    }

    @EventHandler
    public void onPlayerRightClickEntityWithKitItem(PlayerInteractAtEntityEvent event) {
        Entity rightClicked = event.getRightClicked();
        KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(event.getPlayer());
        if (rightClicked instanceof Player) {
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerRightClickPlayerWithKitItem(event, kitPlayer, (Player)rightClicked));
        }
        if (rightClicked instanceof LivingEntity) {
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerRightClickLivingEntityWithKitItem(event, kitPlayer, (LivingEntity)rightClicked));
        }
        this.useKitItem((Event)event, kitPlayer, kit -> kit.onPlayerRightClickEntityWithKitItem(event, kitPlayer, rightClicked));
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        if (entity.getShooter() != null && entity.getShooter() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)entity.getShooter());
            if (event.getHitEntity() != null) {
                this.useKit((Event)event, kitPlayer, kit -> kit.onProjectileHitEvent(event, kitPlayer, event.getHitEntity()));
            }
        }
    }

    @EventHandler
    public void onEntityMoveEvent(EntityMoveEvent event) {
        List passengers = event.getEntity().getPassengers();
        if (passengers.isEmpty()) {
            return;
        }
        for (Entity passenger : passengers) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)passenger);
            this.useKit((Event)event, kitPlayer, kit -> kit.onEntityMoveWithPassengerEvent(event, kitPlayer));
        }
    }

    @EventHandler
    public void onVehicleMoveEvent(VehicleMoveEvent event) {
        List passengers = event.getVehicle().getPassengers();
        if (passengers.isEmpty()) {
            return;
        }
        for (Entity passenger : passengers) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)passenger);
            this.useKit((Event)event, kitPlayer, kit -> kit.onVehicleMoveEvent(event, kitPlayer));
        }
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            KitPlayer kitPlayer = this.playerSupplier.getKitPlayer((Player)event.getEntity());
            this.useKitItem((Event)event, kitPlayer, kit -> kit.onKitPlayerShootBow(event, kitPlayer, event.getProjectile()));
        }
    }

    public void useKit(Event event, KitPlayer kitPlayer, KitExecutor kitExecutor) {
        kitPlayer.getKits().stream().filter(kit -> KitEventHandlerImpl.canUseKit(event, kitPlayer, kit)).forEach(kitExecutor::execute);
    }

    public void useKitItem(Event event, KitPlayer kitPlayer, KitExecutor kitExecutor) {
        kitPlayer.getKits().stream().filter(kit -> !(kit instanceof MultipleKitItemsKit)).filter(kit -> KitEventHandlerImpl.canUseKitItem(event, kitPlayer, kit)).forEach(kitExecutor::execute);
    }

    public void useOneOfMultipleKitItems(Event event, KitPlayer kitPlayer, ItemStack itemStack, KitExecutor kitExecutor) {
        kitPlayer.getKits().stream().filter(kit -> kit instanceof MultipleKitItemsKit).filter(kit -> KitEventHandlerImpl.canUseOneOfMultipleKitItems(event, kitPlayer, (MultipleKitItemsKit)kit, itemStack)).forEach(kitExecutor::execute);
    }
}

