/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.kit.MultipleCooldownsKit;
import de.hglabor.plugins.kitapi.kit.config.Cooldown;
import de.hglabor.plugins.kitapi.kit.items.KitItemAction;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class MultipleKitItemsKit
extends MultipleCooldownsKit<KitItemAction> {
    protected MultipleKitItemsKit(String name, Material displayMaterial) {
        super(name, displayMaterial, new HashMap());
    }

    protected void setItemsAndCooldown(Map<KitItemAction, Float> map) {
        this.cooldowns.putAll(map);
    }

    @Override
    public List<ItemStack> getKitItems() {
        return this.cooldowns.keySet().stream().map(KitItemAction::item).collect(Collectors.toList());
    }

    private KitItemAction byItemStack(ItemStack itemStack) {
        return this.cooldowns.keySet().stream().filter(kitItemAction -> kitItemAction.item().isSimilar(itemStack)).findFirst().orElse(null);
    }

    @Override
    public boolean isKitItem(ItemStack itemStack) {
        return this.getKitItems().stream().anyMatch(item -> item.isSimilar(itemStack));
    }

    protected String getCooldownKey(ItemStack itemStack) {
        return this.getName() + "." + itemStack.getType() + ".cooldown";
    }

    protected void activateCooldown(KitPlayer kitPlayer, ItemStack itemStack) {
        if (!kitPlayer.getKitAttributeOrDefault(this.getCooldownKey(itemStack), new Cooldown(false)).hasCooldown()) {
            kitPlayer.putKitAttribute(this.getCooldownKey(itemStack), new Cooldown(true, this.cooldowns.getOrDefault(this.byItemStack(itemStack), Float.valueOf(0.0f)).floatValue()));
        }
    }

    public boolean sendCooldownMessage(KitPlayer kitPlayer, ItemStack itemStack) {
        KitItemAction kitItemAction = this.byItemStack(itemStack);
        if (kitItemAction == null) {
            return false;
        }
        if (((Float)this.cooldowns.get(kitItemAction)).floatValue() == 0.0f) {
            return false;
        }
        String cooldownKey = this.getCooldownKey(itemStack);
        Cooldown kitCooldown = kitPlayer.getKitAttributeOrDefault(cooldownKey, new Cooldown(false));
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return false;
        }
        if (kitCooldown.hasCooldown()) {
            long timeLeft = kitCooldown.getEndTime() - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                kitPlayer.putKitAttribute(cooldownKey, null);
                return false;
            }
            Locale locale = ChatUtils.locale((Player)player);
            player.sendActionBar(Localization.t((String)"kit.multipleCooldown", (Map)ImmutableMap.of((Object)"numberInSeconds", (Object)String.valueOf((double)timeLeft / 1000.0), (Object)"action", (Object)Localization.t((String)kitItemAction.localizationKey(), (Locale)locale)), (Locale)locale));
            return true;
        }
        return false;
    }
}

