/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.config;

import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.events.KitEventInfo;
import de.hglabor.plugins.kitapi.kit.settings.BoolArg;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.EntityArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.LongArg;
import de.hglabor.plugins.kitapi.kit.settings.MaterialArg;
import de.hglabor.plugins.kitapi.kit.settings.ParticleArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionEffectArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionTypeArg;
import de.hglabor.plugins.kitapi.kit.settings.SoundArg;
import de.hglabor.plugins.kitapi.util.Utils;
import de.hglabor.utils.noriskutils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.NumberConversions;

public final class KitApiConfig {
    private static final KitApiConfig instance = new KitApiConfig();
    private static File kitFile;
    private static YamlConfiguration kitConfiguration;

    private KitApiConfig() {
    }

    public static KitApiConfig getInstance() {
        return instance;
    }

    private String key(AbstractKit kit, String fieldName) {
        return "kit." + kit.getName() + ".settings." + fieldName;
    }

    public void register(File folder) {
        try {
            kitFile = new File(folder, "kitConfig.yml");
            if (!kitFile.exists()) {
                if (!kitFile.getParentFile().exists()) {
                    kitFile.getParentFile().createNewFile();
                }
                kitFile.createNewFile();
            }
            kitConfiguration = YamlConfiguration.loadConfiguration((File)kitFile);
            kitConfiguration.addDefault("kit.amount", (Object)1);
            kitConfiguration.addDefault("debug", (Object)false);
            kitConfiguration.options().copyDefaults(true);
            kitConfiguration.save(kitFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void add(AbstractKit kit) {
        try {
            this.registerAnnotations(kit);
            kitConfiguration.options().copyDefaults(true);
            kitConfiguration.save(kitFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerAnnotations(AbstractKit kit) {
        for (Field field : Utils.getAllFields(kit)) {
            String name = field.getName();
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType().equals(IntArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)ReflectionUtils.getInt((Field)field, (Object)kit));
                    continue;
                }
                if (annotation.annotationType().equals(FloatArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)Float.valueOf(ReflectionUtils.getFloat((Field)field, (Object)kit)));
                    continue;
                }
                if (annotation.annotationType().equals(DoubleArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)ReflectionUtils.getDouble((Field)field, (Object)kit));
                    continue;
                }
                if (annotation.annotationType().equals(LongArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)ReflectionUtils.getLong((Field)field, (Object)kit));
                    continue;
                }
                if (annotation.annotationType().equals(MaterialArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)((Material)ReflectionUtils.get((Field)field, (Object)kit)).name());
                    continue;
                }
                if (annotation.annotationType().equals(PotionTypeArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)((PotionType)ReflectionUtils.get((Field)field, (Object)kit)).name());
                    continue;
                }
                if (annotation.annotationType().equals(EntityArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)((EntityType)ReflectionUtils.get((Field)field, (Object)kit)).name());
                    continue;
                }
                if (annotation.annotationType().equals(PotionEffectArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)((PotionEffectType)ReflectionUtils.get((Field)field, (Object)kit)).getName());
                    continue;
                }
                if (annotation.annotationType().equals(SoundArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)((Sound)ReflectionUtils.get((Field)field, (Object)kit)).name());
                    continue;
                }
                if (annotation.annotationType().equals(BoolArg.class)) {
                    kitConfiguration.addDefault(this.key(kit, name), (Object)ReflectionUtils.getBool((Field)field, (Object)kit));
                    continue;
                }
                if (!annotation.annotationType().equals(ParticleArg.class)) continue;
                kitConfiguration.addDefault(this.key(kit, name), (Object)((Particle)ReflectionUtils.get((Field)field, (Object)kit)).name());
            }
        }
    }

    public void load(AbstractKit kit) {
        for (Field field : Utils.getAllFields(kit)) {
            String name = field.getName();
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (annotation.annotationType().equals(IntArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)NumberConversions.toInt((Object)kitConfiguration.get(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(FloatArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)Float.valueOf(NumberConversions.toFloat((Object)kitConfiguration.get(this.key(kit, name)))));
                    continue;
                }
                if (annotation.annotationType().equals(DoubleArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)NumberConversions.toDouble((Object)kitConfiguration.get(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(LongArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)NumberConversions.toLong((Object)kitConfiguration.get(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(MaterialArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)Material.valueOf((String)kitConfiguration.getString(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(PotionTypeArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)PotionType.valueOf((String)kitConfiguration.getString(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(EntityArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)EntityType.valueOf((String)kitConfiguration.getString(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(PotionEffectArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)PotionEffectType.getByName((String)kitConfiguration.getString(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(SoundArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)Sound.valueOf((String)kitConfiguration.getString(this.key(kit, name))));
                    continue;
                }
                if (annotation.annotationType().equals(BoolArg.class)) {
                    ReflectionUtils.set((Field)field, (Object)kit, (Object)Boolean.valueOf(kitConfiguration.getString(this.key(kit, name))));
                    continue;
                }
                if (!annotation.annotationType().equals(ParticleArg.class)) continue;
                ReflectionUtils.set((Field)field, (Object)kit, (Object)Particle.valueOf((String)kitConfiguration.getString(this.key(kit, name))));
            }
        }
        this.loadKitEvents(kit);
    }

    private void loadKitEvents(AbstractKit kit) {
        for (Method method : kit.getClass().getDeclaredMethods()) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(KitEvent.class)) continue;
                Class<?> clazz = ((KitEvent)annotation).clazz();
                if (!clazz.equals(Void.class)) {
                    kit.getKitEvents().add(new KitEventInfo(((KitEvent)annotation).ignoreCooldown(), clazz));
                    continue;
                }
                for (Class<?> param : method.getParameterTypes()) {
                    if (!Event.class.isAssignableFrom(param)) continue;
                    kit.getKitEvents().add(new KitEventInfo(((KitEvent)annotation).ignoreCooldown(), param));
                }
            }
        }
    }

    public int getInteger(String key) {
        return kitConfiguration.getInt(key);
    }

    public String getString(String key) {
        return kitConfiguration.getString(key);
    }

    public boolean getBoolean(String key) {
        return kitConfiguration.getBoolean(key);
    }

    public int getKitAmount() {
        return kitConfiguration.getInt("kit.amount");
    }
}

