/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.config.KitApiConfig;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.Passive;
import de.hglabor.plugins.kitapi.kit.config.Cooldown;
import de.hglabor.plugins.kitapi.kit.kits.ArcherKit;
import de.hglabor.plugins.kitapi.kit.kits.AutomaticKit;
import de.hglabor.plugins.kitapi.kit.kits.BearKit;
import de.hglabor.plugins.kitapi.kit.kits.BeequeenKit;
import de.hglabor.plugins.kitapi.kit.kits.BlinkKit;
import de.hglabor.plugins.kitapi.kit.kits.BomberKit;
import de.hglabor.plugins.kitapi.kit.kits.CannibalKit;
import de.hglabor.plugins.kitapi.kit.kits.ChameleonKit;
import de.hglabor.plugins.kitapi.kit.kits.ChemistKit;
import de.hglabor.plugins.kitapi.kit.kits.ClawKit;
import de.hglabor.plugins.kitapi.kit.kits.CookiemonsterKit;
import de.hglabor.plugins.kitapi.kit.kits.CopyCatKit;
import de.hglabor.plugins.kitapi.kit.kits.DannyKit;
import de.hglabor.plugins.kitapi.kit.kits.DemomanKit;
import de.hglabor.plugins.kitapi.kit.kits.DiggerKit;
import de.hglabor.plugins.kitapi.kit.kits.ElytraKit;
import de.hglabor.plugins.kitapi.kit.kits.FahrradKit;
import de.hglabor.plugins.kitapi.kit.kits.FalcoKit;
import de.hglabor.plugins.kitapi.kit.kits.GamblerKit;
import de.hglabor.plugins.kitapi.kit.kits.GardenerKit;
import de.hglabor.plugins.kitapi.kit.kits.GhostKit;
import de.hglabor.plugins.kitapi.kit.kits.GladiatorKit;
import de.hglabor.plugins.kitapi.kit.kits.GravityKit;
import de.hglabor.plugins.kitapi.kit.kits.GripperKit;
import de.hglabor.plugins.kitapi.kit.kits.HemomancerKit;
import de.hglabor.plugins.kitapi.kit.kits.HulkKit;
import de.hglabor.plugins.kitapi.kit.kits.IrongolemKit;
import de.hglabor.plugins.kitapi.kit.kits.JackhammerKit;
import de.hglabor.plugins.kitapi.kit.kits.KayaKit;
import de.hglabor.plugins.kitapi.kit.kits.LifestealerKit;
import de.hglabor.plugins.kitapi.kit.kits.LumberjackKit;
import de.hglabor.plugins.kitapi.kit.kits.MagmaKit;
import de.hglabor.plugins.kitapi.kit.kits.ManipulationKit;
import de.hglabor.plugins.kitapi.kit.kits.MedusaKit;
import de.hglabor.plugins.kitapi.kit.kits.MonkKit;
import de.hglabor.plugins.kitapi.kit.kits.NinjaKit;
import de.hglabor.plugins.kitapi.kit.kits.NoneKit;
import de.hglabor.plugins.kitapi.kit.kits.OpaKit;
import de.hglabor.plugins.kitapi.kit.kits.PenguinKit;
import de.hglabor.plugins.kitapi.kit.kits.PerfectKit;
import de.hglabor.plugins.kitapi.kit.kits.PoseidonKit;
import de.hglabor.plugins.kitapi.kit.kits.RandomKit;
import de.hglabor.plugins.kitapi.kit.kits.ReaperKit;
import de.hglabor.plugins.kitapi.kit.kits.RefillKit;
import de.hglabor.plugins.kitapi.kit.kits.ReviveKit;
import de.hglabor.plugins.kitapi.kit.kits.RogueKit;
import de.hglabor.plugins.kitapi.kit.kits.ScaffoldKit;
import de.hglabor.plugins.kitapi.kit.kits.ScientistKit;
import de.hglabor.plugins.kitapi.kit.kits.ScoutKit;
import de.hglabor.plugins.kitapi.kit.kits.ShadowKit;
import de.hglabor.plugins.kitapi.kit.kits.ShapeShifterKit;
import de.hglabor.plugins.kitapi.kit.kits.ShulkerKit;
import de.hglabor.plugins.kitapi.kit.kits.SlimeKit;
import de.hglabor.plugins.kitapi.kit.kits.SmogmogKit;
import de.hglabor.plugins.kitapi.kit.kits.SnailKit;
import de.hglabor.plugins.kitapi.kit.kits.SoulstealerKit;
import de.hglabor.plugins.kitapi.kit.kits.SpidermanKit;
import de.hglabor.plugins.kitapi.kit.kits.SpiegelKit;
import de.hglabor.plugins.kitapi.kit.kits.SpitKit;
import de.hglabor.plugins.kitapi.kit.kits.SquidKit;
import de.hglabor.plugins.kitapi.kit.kits.StomperKit;
import de.hglabor.plugins.kitapi.kit.kits.SurpriseKit;
import de.hglabor.plugins.kitapi.kit.kits.SwitcherKit;
import de.hglabor.plugins.kitapi.kit.kits.TankKit;
import de.hglabor.plugins.kitapi.kit.kits.ThorKit;
import de.hglabor.plugins.kitapi.kit.kits.TrashtalkerKit;
import de.hglabor.plugins.kitapi.kit.kits.VampireKit;
import de.hglabor.plugins.kitapi.kit.kits.VentKit;
import de.hglabor.plugins.kitapi.kit.kits.ViperKit;
import de.hglabor.plugins.kitapi.kit.kits.ZickZackKit;
import de.hglabor.plugins.kitapi.kit.kits.analyst.AnalystKit;
import de.hglabor.plugins.kitapi.kit.kits.endermage.EndermageKit;
import de.hglabor.plugins.kitapi.kit.kits.grappler.GrapplerKit;
import de.hglabor.plugins.kitapi.kit.passives.FastBreakPassive;
import de.hglabor.plugins.kitapi.kit.passives.GravediggerPassive;
import de.hglabor.plugins.kitapi.kit.passives.NoSoupDropPassive;
import de.hglabor.plugins.kitapi.kit.passives.NonePassive;
import de.hglabor.plugins.kitapi.kit.passives.PeacemakerPassive;
import de.hglabor.plugins.kitapi.kit.selector.KitSelector;
import de.hglabor.plugins.kitapi.kit.selector.PassiveSelector;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.supplier.KitItemSupplier;
import de.hglabor.plugins.kitapi.supplier.KitItemSupplierImpl;
import de.hglabor.plugins.kitapi.supplier.KitPlayerSupplier;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.feast.Feast;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class KitApi {
    private static final KitApi INSTANCE = new KitApi();
    public final List<AbstractKit> kits = new ArrayList<AbstractKit>();
    private final List<Locale> supportedLanguages;
    private KitSelector kitSelector;
    private PassiveSelector passiveSelector;
    private KitPlayerSupplier playerSupplier;
    private KitItemSupplier itemSupplier = KitItemSupplierImpl.INSTANCE;
    private JavaPlugin plugin;
    private Feast feast;

    private KitApi() {
        this.supportedLanguages = Arrays.asList(Locale.ENGLISH, Locale.GERMAN);
    }

    public static KitApi getInstance() {
        return INSTANCE;
    }

    public void checkUsesForCooldown(KitPlayer kitPlayer, AbstractKit kit, int maxUses) {
        AtomicInteger kitUses;
        String key = kit.getName() + "kitUses";
        if (kitPlayer.getKitAttribute(key) == null) {
            kitPlayer.putKitAttribute(key, new AtomicInteger());
        }
        if ((kitUses = (AtomicInteger)kitPlayer.getKitAttribute(key)).getAndIncrement() > maxUses) {
            kitPlayer.activateKitCooldown(kit);
            kitUses.set(0);
        }
    }

    public String cooldownKey(AbstractKit kit) {
        return kit.getName() + "cooldown";
    }

    public void checkUsesForCooldown(Player player, AbstractKit kit, int maxUses) {
        this.checkUsesForCooldown(this.getPlayer(player), kit, maxUses);
    }

    public List<Locale> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public List<AbstractKit> emptyKitList() {
        int kitAmount = KitApiConfig.getInstance().getKitAmount();
        ArrayList<AbstractKit> emptyKitList = new ArrayList<AbstractKit>(kitAmount);
        for (int i = 0; i < kitAmount; ++i) {
            emptyKitList.add(NoneKit.INSTANCE);
        }
        return emptyKitList;
    }

    public void enableKit(AbstractKit kit, boolean isEnabled) {
        kit.setEnabled(isEnabled);
        if (isEnabled) {
            if (kit instanceof Listener) {
                Bukkit.getPluginManager().registerEvents((Listener)kit, (Plugin)this.plugin);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                KitPlayer kitPlayer = this.playerSupplier.getKitPlayer(player);
                if (!kitPlayer.hasKit(kit)) continue;
                kit.onEnable(kitPlayer);
            }
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                kit.onDeactivation(this.playerSupplier.getKitPlayer(player));
            }
            if (kit instanceof Listener) {
                HandlerList.unregisterAll((Listener)((Listener)kit));
            }
        }
    }

    public void register(KitPlayerSupplier kitPlayerSupplier, KitSelector kitSelector, PassiveSelector passiveSelector, JavaPlugin plugin, Path path) {
        KitApiConfig.getInstance().register(path.toFile());
        this.playerSupplier = kitPlayerSupplier;
        this.kitSelector = kitSelector;
        this.passiveSelector = passiveSelector;
        this.plugin = plugin;
        if (kitSelector != null) {
            plugin.getServer().getPluginManager().registerEvents((Listener)kitSelector, (Plugin)plugin);
        }
        if (passiveSelector != null) {
            plugin.getServer().getPluginManager().registerEvents((Listener)passiveSelector, (Plugin)plugin);
        }
        this.kits.add(MagmaKit.INSTANCE);
        this.kits.add(NinjaKit.INSTANCE);
        this.kits.add(NoneKit.INSTANCE);
        this.kits.add(BlinkKit.INSTANCE);
        this.kits.add(SurpriseKit.INSTANCE);
        this.kits.add(CopyCatKit.INSTANCE);
        this.kits.add(GladiatorKit.INSTANCE);
        this.kits.add(GamblerKit.INSTANCE);
        this.kits.add(SmogmogKit.INSTANCE);
        this.kits.add(RogueKit.INSTANCE);
        this.kits.add(SnailKit.INSTANCE);
        this.kits.add(DiggerKit.INSTANCE);
        this.kits.add(FahrradKit.INSTANCE);
        this.kits.add(ReviveKit.INSTANCE);
        this.kits.add(TankKit.INSTANCE);
        this.kits.add(GravityKit.INSTANCE);
        this.kits.add(CannibalKit.INSTANCE);
        this.kits.add(ZickZackKit.INSTANCE);
        this.kits.add(ThorKit.INSTANCE);
        this.kits.add(TrashtalkerKit.INSTANCE);
        this.kits.add(StomperKit.INSTANCE);
        this.kits.add(DannyKit.INSTANCE);
        this.kits.add(JackhammerKit.INSTANCE);
        this.kits.add(IrongolemKit.INSTANCE);
        this.kits.add(SwitcherKit.INSTANCE);
        this.kits.add(SpitKit.INSTANCE);
        this.kits.add(SquidKit.INSTANCE);
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            this.kits.add(ShapeShifterKit.INSTANCE);
        }
        this.kits.add(SpidermanKit.INSTANCE);
        this.kits.add(ManipulationKit.INSTANCE);
        this.kits.add(EndermageKit.INSTANCE);
        this.kits.add(ViperKit.INSTANCE);
        this.kits.add(LumberjackKit.INSTANCE);
        this.kits.add(ReaperKit.INSTANCE);
        this.kits.add(GrapplerKit.INSTANCE);
        this.kits.add(ClawKit.INSTANCE);
        this.kits.add(AutomaticKit.INSTANCE);
        this.kits.add(OpaKit.INSTANCE);
        this.kits.add(ScoutKit.INSTANCE);
        this.kits.add(MonkKit.INSTANCE);
        this.kits.add(VampireKit.INSTANCE);
        this.kits.add(VentKit.INSTANCE);
        this.kits.add(KayaKit.INSTANCE);
        this.kits.add(SoulstealerKit.INSTANCE);
        this.kits.add(AnalystKit.INSTANCE);
        this.kits.add(HulkKit.INSTANCE);
        this.kits.add(DemomanKit.INSTANCE);
        this.kits.add(GardenerKit.INSTANCE);
        this.kits.add(GhostKit.INSTANCE);
        this.kits.add(BeequeenKit.INSTANCE);
        this.kits.add(PoseidonKit.INSTANCE);
        this.kits.add(RandomKit.INSTANCE);
        this.kits.add(ElytraKit.INSTANCE);
        this.kits.add(ArcherKit.INSTANCE);
        this.kits.add(HemomancerKit.INSTANCE);
        this.kits.add(SpiegelKit.INSTANCE);
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            this.kits.add(ChameleonKit.INSTANCE);
        }
        this.kits.add(ChemistKit.INSTANCE);
        this.kits.add(RefillKit.INSTANCE);
        this.kits.add(BearKit.INSTANCE);
        this.kits.add(ShulkerKit.INSTANCE);
        this.kits.add(CookiemonsterKit.INSTANCE);
        this.kits.add(GripperKit.INSTANCE);
        this.kits.add(PenguinKit.INSTANCE);
        this.kits.add(PerfectKit.INSTANCE);
        this.kits.add(SlimeKit.INSTANCE);
        this.kits.add(ScaffoldKit.INSTANCE);
        this.kits.add(MedusaKit.INSTANCE);
        this.kits.add(ShadowKit.INSTANCE);
        this.kits.add(LifestealerKit.INSTANCE);
        this.kits.add(BomberKit.INSTANCE);
        this.kits.add(ScientistKit.INSTANCE);
        this.kits.add(FalcoKit.INSTANCE);
        this.kits.add(NonePassive.INSTANCE);
        this.kits.add(FastBreakPassive.INSTANCE);
        this.kits.add(GravediggerPassive.INSTANCE);
        this.kits.add(NoSoupDropPassive.INSTANCE);
        this.kits.add(PeacemakerPassive.INSTANCE);
        this.kits.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.registerKits();
        if (kitSelector != null) {
            kitSelector.load();
        }
        if (passiveSelector != null) {
            passiveSelector.load();
        }
    }

    private void registerKits() {
        KitApiConfig kitApiConfig = KitApiConfig.getInstance();
        for (AbstractKit kit : this.kits) {
            System.out.println(kit.getName());
            kitApiConfig.add(kit);
            kitApiConfig.load(kit);
            if (!(kit instanceof Listener)) continue;
            this.plugin.getServer().getPluginManager().registerEvents((Listener)kit, (Plugin)this.plugin);
        }
    }

    public KitItemSupplier getItemSupplier() {
        return this.itemSupplier;
    }

    public void setItemSupplier(KitItemSupplier itemSupplier) {
        this.itemSupplier = itemSupplier;
    }

    public List<AbstractKit> getEnabledKits() {
        return this.kits.stream().filter(AbstractKit::isEnabled).filter(it -> !(it instanceof Passive)).collect(Collectors.toList());
    }

    public List<Passive> getEnabledPassives() {
        return this.kits.stream().filter(AbstractKit::isEnabled).filter(it -> it instanceof Passive).map(it -> (Passive)it).collect(Collectors.toList());
    }

    public List<AbstractKit> getAllKits() {
        return this.kits;
    }

    public AbstractKit getAlphabeticallyKit(int index) {
        ArrayList<AbstractKit> kits = new ArrayList<AbstractKit>(this.getEnabledKits());
        kits.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return (AbstractKit)kits.get(index);
    }

    public AbstractKit getAlphabeticallyPassive(int index) {
        ArrayList<Passive> kits = new ArrayList<Passive>(this.getEnabledPassives());
        kits.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return (AbstractKit)kits.get(index);
    }

    public AbstractKit byItem(ItemStack itemStack) {
        for (AbstractKit kit : this.kits) {
            if (!kit.getDisplayItems().stream().anyMatch(displayItem -> displayItem.isSimilar(itemStack))) continue;
            return kit;
        }
        return null;
    }

    public KitPlayer getPlayer(Player player) {
        return this.playerSupplier.getKitPlayer(player);
    }

    public KitPlayer getRandomAlivePlayer() {
        return this.playerSupplier.getRandomAlivePlayer();
    }

    public boolean hasKitItemInAnyHand(Player player, AbstractKit kit) {
        if (kit.getMainKitItem() != null && kit.getMainKitItem().getType().equals((Object)Material.AIR) && player.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR)) {
            return true;
        }
        return player.getInventory().getItemInOffHand().isSimilar(kit.getMainKitItem()) || player.getInventory().getItemInMainHand().isSimilar(kit.getMainKitItem());
    }

    public void giveKitItemsIfInvFull(KitPlayer kitPlayer, AbstractKit kit) {
        this.itemSupplier.giveKitItems(kitPlayer, kit);
    }

    public void giveKitItemsIfInvFull(KitPlayer kitPlayer, AbstractKit kit, List<ItemStack> items) {
        this.itemSupplier.giveKitItems(kitPlayer, kit, items);
    }

    public void giveItemsIfSlotEmpty(KitPlayer kitPlayer, List<ItemStack> kits) {
        this.itemSupplier.giveItems(kitPlayer, kits);
    }

    public void removeKitItems(AbstractKit kit, Player player) {
        player.getInventory().removeItem(kit.getKitItems().toArray(new ItemStack[0]));
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public KitSelector getKitSelector() {
        return this.kitSelector;
    }

    public PassiveSelector getPassiveSelector() {
        return this.passiveSelector;
    }

    public KitPlayerSupplier getPlayerSupplier() {
        return this.playerSupplier;
    }

    public boolean sendCooldownMessage(KitPlayer kitPlayer, AbstractKit kit) {
        if (kit.getCooldown() > 0.0f) {
            Cooldown kitCooldown = kitPlayer.getKitCooldown(kit);
            Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
            if (player == null) {
                return false;
            }
            if (kitCooldown.hasCooldown()) {
                long timeLeft = kitCooldown.getEndTime() - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    kitPlayer.clearCooldown(kit);
                    return false;
                }
                if (kit.getMainKitItem() != null && this.hasKitItemInAnyHand(player, kit)) {
                    player.sendActionBar(Localization.INSTANCE.getMessage("kit.cooldown", (Map)ImmutableMap.of((Object)"numberInSeconds", (Object)String.valueOf((double)timeLeft / 1000.0)), ChatUtils.locale((Player)player)));
                } else if (kit.getMainKitItem() == null) {
                    player.sendActionBar(Localization.INSTANCE.getMessage("kit.cooldown", (Map)ImmutableMap.of((Object)"numberInSeconds", (Object)String.valueOf((double)timeLeft / 1000.0)), ChatUtils.locale((Player)player)));
                }
                return true;
            }
        }
        return false;
    }

    public Feast getFeast() {
        return this.feast;
    }

    public void setFeast(Feast feast) {
        if (this.feast == null) {
            this.feast = feast;
        }
    }
}

