/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.staffmode;

import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.staffmode.IStaffPlayer;
import de.hglabor.utils.noriskutils.staffmode.IStaffPlayerSupplier;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerHider
implements Listener {
    private final JavaPlugin plugin;
    private final IStaffPlayerSupplier supplier;

    public PlayerHider(IStaffPlayerSupplier supplier, JavaPlugin plugin) {
        this.supplier = supplier;
        this.plugin = plugin;
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        Player joined = event.getPlayer();
        this.supplier.getStaffPlayer(joined).ifPresent(iStaffPlayer -> {
            if (iStaffPlayer.canSeeStaffModePlayers()) {
                return;
            }
            for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
                this.supplier.getStaffPlayer(otherPlayer).ifPresent(otherStaffPlayer -> {
                    if (otherStaffPlayer.isStaffMode() && !otherStaffPlayer.isVisible()) {
                        joined.hidePlayer((Plugin)this.plugin, otherPlayer);
                    }
                });
            }
        });
    }

    public void hide(Player playerToHide) {
        this.supplier.getStaffPlayer(playerToHide).ifPresent(iStaffPlayer -> {
            iStaffPlayer.setVisible(false);
            playerToHide.sendActionBar(Localization.INSTANCE.getMessage("staffmode.hidden", ChatUtils.locale(playerToHide)));
            for (Player player : Bukkit.getOnlinePlayers()) {
                Optional<IStaffPlayer> staffPlayer = this.supplier.getStaffPlayer(player);
                if (player.hasPermission("hglabor.staffmode") && (staffPlayer.isEmpty() || staffPlayer.get().canSeeStaffModePlayers() || staffPlayer.get().isStaffMode())) continue;
                player.hidePlayer((Plugin)this.plugin, playerToHide);
            }
        });
    }

    public void show(Player playerToShow) {
        this.supplier.getStaffPlayer(playerToShow).ifPresent(iStaffPlayer -> iStaffPlayer.setVisible(true));
        playerToShow.sendActionBar(Localization.INSTANCE.getMessage("staffmode.visible", ChatUtils.locale(playerToShow)));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.showPlayer((Plugin)this.plugin, playerToShow);
        }
    }

    public void hideEveryoneInStaffMode(Player player) {
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            this.supplier.getStaffPlayer(otherPlayer).ifPresent(iStaffPlayer -> {
                if (iStaffPlayer.isStaffMode()) {
                    player.hidePlayer((Plugin)this.plugin, otherPlayer);
                }
            });
        }
    }

    public void showEveryoneInStaffMode(Player player) {
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            this.supplier.getStaffPlayer(otherPlayer).ifPresent(iStaffPlayer -> {
                if (iStaffPlayer.isStaffMode()) {
                    player.showPlayer((Plugin)this.plugin, otherPlayer);
                }
            });
        }
    }

    public IStaffPlayerSupplier getSupplier() {
        return this.supplier;
    }
}

