/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.pvpbots;

import de.hglabor.utils.noriskutils.NMSUtils;
import de.hglabor.utils.noriskutils.pvpbots.goal.PvPBotMeleeAttackGoal;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PvPBot
extends net.minecraft.world.entity.monster.Zombie {
    public static final String META_DATA = "pvpBot";
    private final String name;
    private final PlayerDisguise playerDisguise;
    protected net.minecraft.world.entity.LivingEntity target;
    protected double attackRange = 10.0;
    private boolean isDefaultPathfinderTarget;

    public PvPBot(World world, String name, org.bukkit.entity.Player player, JavaPlugin plugin) {
        this(world, name, NMSUtils.getEntityLiving((LivingEntity)player), plugin);
    }

    public PvPBot(World world, String name, JavaPlugin plugin) {
        super((Level)((CraftWorld)world).getHandle());
        this.name = name;
        this.level.addFreshEntity((net.minecraft.world.entity.Entity)this);
        this.getEntity().setMetadata(META_DATA, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)""));
        this.getEntity().setShouldBurnInDay(false);
        this.getEntity().setRemoveWhenFarAway(false);
        this.setCustomName((Component)new TextComponent(name));
        this.setCustomNameVisible(true);
        this.playerDisguise = new PlayerDisguise(name);
        this.playerDisguise.setNameVisible(true);
        this.playerDisguise.setDisplayedInTab(false);
        this.isDefaultPathfinderTarget = true;
        this.initPathfinder();
        DisguiseAPI.disguiseEntity((Entity)this.getBukkitEntity(), (Disguise)this.playerDisguise);
    }

    public PvPBot(World world, String name, net.minecraft.world.entity.LivingEntity target, JavaPlugin plugin) {
        super((Level)((CraftWorld)world).getHandle());
        this.name = name;
        this.target = target;
        this.level.addFreshEntity((net.minecraft.world.entity.Entity)this);
        this.getEntity().setMetadata(META_DATA, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)""));
        this.getEntity().setShouldBurnInDay(false);
        this.getEntity().setRemoveWhenFarAway(false);
        this.setCustomName((Component)new TextComponent(name));
        this.setCustomNameVisible(true);
        this.playerDisguise = new PlayerDisguise(name);
        this.playerDisguise.setNameVisible(true);
        DisguiseAPI.disguiseEntity((Entity)this.getBukkitEntity(), (Disguise)this.playerDisguise);
        this.setTarget(target, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
    }

    public ResourceLocation getDefaultLootTable() {
        return null;
    }

    public void spawn(Location location) {
        this.setPos(location.getX(), location.getY(), location.getZ());
    }

    public PvPBot withRange(double range) {
        this.attackRange = range * range;
        return this;
    }

    public PvPBot withItemInSlot(EquipmentSlot slot, ItemStack itemStack) {
        EntityEquipment equipment = this.getEntity().getEquipment();
        if (equipment != null) {
            equipment.setItem(slot, itemStack);
        }
        return this;
    }

    public PvPBot withMovementSpeed(double speed) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (attribute != null) {
            attribute.setBaseValue(speed);
        }
        return this;
    }

    public PvPBot withSkin(String skin) {
        this.playerDisguise.setSkin(skin);
        return this;
    }

    public PvPBot withDisplayInTab(boolean value) {
        this.playerDisguise.setDisplayedInTab(value);
        return this;
    }

    public PvPBot withFollowRange(double followRange) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_FOLLOW_RANGE);
        if (attribute != null) {
            attribute.setBaseValue(followRange);
        }
        return this;
    }

    public PvPBot withHealth(int health) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute != null) {
            attribute.setBaseValue((double)health);
        }
        this.setHealth(health);
        return this;
    }

    public PvPBot withDefaultPathfinderTarget(boolean value) {
        this.isDefaultPathfinderTarget = value;
        return this;
    }

    protected void initPathfinder() {
        this.goalSelector.addGoal(0, (Goal)new PvPBotMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        if (this.isDefaultPathfinderTarget) {
            this.goalSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        } else {
            this.goalSelector.addGoal(1, (Goal)new PathfinderFindTarget());
        }
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
    }

    protected boolean shouldDropExperience() {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return source == DamageSource.ON_FIRE ? SoundEvents.PLAYER_HURT_ON_FIRE : (source == DamageSource.DROWN ? SoundEvents.PLAYER_HURT_DROWN : (source == DamageSource.SWEET_BERRY_BUSH ? SoundEvents.PLAYER_HURT_SWEET_BERRY_BUSH : (source == DamageSource.FREEZE ? SoundEvents.PLAYER_HURT_FREEZE : SoundEvents.PLAYER_HURT)));
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    public Zombie getEntity() {
        return (Zombie)this.getBukkitEntity();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.GRASS_STEP;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
    }

    private class PathfinderFindTarget
    extends Goal {
        private PathfinderFindTarget() {
        }

        public boolean canUse() {
            if (PvPBot.this.target == null) {
                return false;
            }
            PvPBot.this.setTarget(PvPBot.this.target, EntityTargetEvent.TargetReason.CUSTOM, true);
            return true;
        }

        public void start() {
        }

        public boolean isInterruptable() {
            return false;
        }
    }
}

