/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PermissionUtils {
    private static final List<String> groups = List.of("admin", "coder", "mod+", "moderator", "media", "creativity", "default");
    private static final Map<String, Integer> groupWeight = new HashMap<String, Integer>();

    private PermissionUtils() {
    }

    public static boolean checkForHigherRank(Player player) {
        String playerGroup = PermissionUtils.getPlayerGroup(player, groups);
        if ("admin".equalsIgnoreCase(playerGroup)) {
            return false;
        }
        int weight = groupWeight.getOrDefault(playerGroup, 0);
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            String group = PermissionUtils.getPlayerGroup(otherPlayer, groups);
            if (groupWeight.getOrDefault(group, 0) <= weight) continue;
            return true;
        }
        return false;
    }

    public static String getPlayerGroup(Player player) {
        return PermissionUtils.getPlayerGroup(player, groups);
    }

    public static String getPlayerGroup(Player player, Collection<String> possibleGroups) {
        for (String group : possibleGroups) {
            if (!player.hasPermission("group." + group)) continue;
            return group;
        }
        return "default";
    }

    static {
        groupWeight.put("admin", 1000);
        groupWeight.put("coder", 900);
        groupWeight.put("mod+", 800);
        groupWeight.put("moderator", 700);
        groupWeight.put("media", 600);
        groupWeight.put("creativity", 500);
        groupWeight.put("default", 0);
    }
}

