/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class InventoryBuilder {
    private String inventoryName = "Inventory Title";
    private InventoryType inventoryType = null;
    private int inventorySlots = 9;
    private Plugin plugin;
    private HashMap<Integer, ItemStack> items = new HashMap();
    private HashMap<ItemStack, Consumer<InventoryClickEvent>> clickActions = new HashMap();

    public InventoryBuilder(Plugin plugin) {
        this.plugin = plugin;
    }

    public InventoryBuilder withItem(ItemStack itemStack, int slot) {
        this.items.put(slot, itemStack);
        this.clickActions.put(itemStack, clickEvent -> {});
        return this;
    }

    public InventoryBuilder withItem(ItemStack itemStack, int slot, Consumer<InventoryClickEvent> clickAction) {
        this.items.put(slot, itemStack);
        this.clickActions.put(itemStack, clickAction);
        return this;
    }

    public InventoryBuilder withType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }

    public InventoryBuilder withSlots(int slots) {
        this.inventorySlots = slots;
        return this;
    }

    public InventoryBuilder withName(String name) {
        this.inventoryName = name;
        return this;
    }

    public Inventory build() {
        Inventory inventory = this.inventoryType != null ? Bukkit.createInventory(null, (InventoryType)this.inventoryType, (String)this.inventoryName) : Bukkit.createInventory(null, (int)this.inventorySlots, (String)this.inventoryName);
        for (final int i : this.items.keySet()) {
            inventory.setItem(i, this.items.get(i));
            final Consumer<InventoryClickEvent> consumer = this.clickActions.get(this.items.get(i));
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onInventoryClick(InventoryClickEvent event) {
                    Player player = (Player)event.getWhoClicked();
                    if (event.getClickedInventory() != null && event.getView().getTitle().equalsIgnoreCase(InventoryBuilder.this.inventoryName) && event.getCurrentItem() != null && event.getCurrentItem().isSimilar(InventoryBuilder.this.items.get(i))) {
                        event.setCancelled(true);
                        consumer.accept(event);
                        event.getHandlers().unregister((Listener)this);
                    }
                }
            }, this.plugin);
        }
        return inventory;
    }
}

