/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.staffmode;

import com.google.common.collect.ImmutableList;
import de.hglabor.utils.noriskutils.ItemBuilder;
import de.hglabor.utils.noriskutils.staffmode.IStaffPlayer;
import de.hglabor.utils.noriskutils.staffmode.IStaffPlayerSupplier;
import de.hglabor.utils.noriskutils.staffmode.PlayerHider;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class StaffModeManager
implements Listener {
    public static final StaffModeManager INSTANCE = new StaffModeManager();
    protected final ItemStack INVENTORY_VIEWER = new ItemBuilder(Material.BLAZE_ROD).setName("Inventory Viewer").build();
    protected final ItemStack RANDOM_TELEPORT = new ItemBuilder(Material.PLAYER_HEAD).setName("Random Teleport").build();
    protected final ItemStack PLAYER_STATS = new ItemBuilder(Material.REDSTONE_BLOCK).setName("Player Stats").build();
    protected final ItemStack TOGGLE_VISIBILITY = new ItemBuilder(Material.NETHER_STAR).setName("Toggle Visibility").build();
    protected final ItemStack TOGGLE_BUILD_MODE = new ItemBuilder(Material.BRICK).setName("Toggle Build Mode").build();
    protected PlayerHider playerHider;
    protected JavaPlugin plugin;
    protected IStaffPlayerSupplier staffPlayerSupplier;

    private StaffModeManager() {
    }

    public void onEnable(JavaPlugin plugin, IStaffPlayerSupplier staffPlayerSupplier, String staffModePermission) {
        if (this.plugin != null) {
            return;
        }
        this.plugin = plugin;
        this.staffPlayerSupplier = staffPlayerSupplier;
        this.playerHider = new PlayerHider(staffPlayerSupplier, plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerHider, (Plugin)plugin);
    }

    public PlayerHider getPlayerHider() {
        return this.playerHider;
    }

    public void sendStaffModeInformation() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.staffPlayerSupplier.getStaffPlayer(player).ifPresent(staffPlayer -> {
                if (!staffPlayer.isStaffMode()) {
                    return;
                }
                String buildInfo = staffPlayer.isBuildMode() ? ChatColor.GREEN + "Buildmode" : ChatColor.RED + "No Buildmode";
                String visibilityInfo = staffPlayer.isVisible() ? ChatColor.GREEN + "Visible" : ChatColor.RED + "Hidden";
                player.sendActionBar(visibilityInfo + " - " + buildInfo);
            });
        }
    }

    public List<ItemStack> getStaffModeItems() {
        return ImmutableList.of((Object)this.RANDOM_TELEPORT, (Object)this.INVENTORY_VIEWER, (Object)this.PLAYER_STATS, (Object)this.TOGGLE_VISIBILITY, (Object)this.TOGGLE_BUILD_MODE);
    }

    @EventHandler
    public void onPlayerInteractAtEntityEvent(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        this.staffPlayerSupplier.getStaffPlayer(player).ifPresent(iStaffPlayer -> {
            ItemStack item = player.getInventory().getItem(event.getHand());
            if (!iStaffPlayer.isStaffMode()) {
                return;
            }
            if (!(event.getRightClicked() instanceof Player)) {
                return;
            }
            if (item == null) {
                return;
            }
            Player rightClicked = (Player)event.getRightClicked();
            if (item.isSimilar(StaffModeManager.INSTANCE.PLAYER_STATS)) {
                iStaffPlayer.printStatsOf(rightClicked);
            } else if (item.isSimilar(StaffModeManager.INSTANCE.INVENTORY_VIEWER)) {
                player.openInventory((Inventory)rightClicked.getInventory());
            }
        });
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        this.staffPlayerSupplier.getStaffPlayer(player).ifPresent(iStaffPlayer -> {
            if (!iStaffPlayer.isStaffMode()) {
                return;
            }
            if (!iStaffPlayer.isBuildMode()) {
                event.setCancelled(true);
            } else {
                player.sendMessage(ChatColor.RED + "You can only break blocks in build mode");
            }
        });
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        this.staffPlayerSupplier.getStaffPlayer(player).ifPresent(iStaffPlayer -> {
            if (!iStaffPlayer.isStaffMode()) {
                return;
            }
            if (!iStaffPlayer.isBuildMode()) {
                event.setCancelled(true);
            } else {
                player.sendMessage(ChatColor.RED + "You can only place blocks in build mode");
            }
        });
    }

    @EventHandler
    public void onPlayerAttemptPickupItem(PlayerAttemptPickupItemEvent event) {
        Player player = event.getPlayer();
        this.staffPlayerSupplier.getStaffPlayer(player).ifPresent(iStaffPlayer -> {
            if (!iStaffPlayer.isStaffMode()) {
                return;
            }
            if (!iStaffPlayer.isBuildMode()) {
                event.setCancelled(true);
            } else {
                player.sendMessage(ChatColor.RED + "You can only pickup items in build mode");
            }
        });
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (!event.hasItem()) {
            return;
        }
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        Optional<IStaffPlayer> optionalIStaffPlayer = this.staffPlayerSupplier.getStaffPlayer(player);
        if (optionalIStaffPlayer.isEmpty()) {
            return;
        }
        IStaffPlayer staffPlayer = optionalIStaffPlayer.get();
        if (!staffPlayer.isStaffMode() || item == null) {
            return;
        }
        if (item.isSimilar(StaffModeManager.INSTANCE.RANDOM_TELEPORT)) {
            this.staffPlayerSupplier.getRandomActivePlayer().ifPresent(arg_0 -> ((Player)player).teleport(arg_0));
            return;
        }
        if (item.isSimilar(StaffModeManager.INSTANCE.TOGGLE_VISIBILITY)) {
            if (staffPlayer.isVisible()) {
                this.playerHider.hide(player);
            } else {
                this.playerHider.show(player);
            }
            return;
        }
        if (item.isSimilar(StaffModeManager.INSTANCE.TOGGLE_BUILD_MODE)) {
            staffPlayer.setBuildMode(!staffPlayer.isBuildMode());
            return;
        }
    }
}

