/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.scoreboard.board;

import de.hglabor.utils.noriskutils.scoreboard.board.BoardFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.axay.kspigot.runnables.KSpigotRunnable;
import net.axay.kspigot.runnables.KSpigotRunnablesKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001;B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0+J\u001c\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020)2\n\u0010,\u001a\u00060\u0007R\u00020\u0000J\u0018\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\u001aJ\u0014\u0010.\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0+J\u000e\u0010.\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001aJ\u0006\u0010/\u001a\u00020$J\u0012\u00100\u001a\u00020$2\n\u0010,\u001a\u00060\u0007R\u00020\u0000J\u000e\u00100\u001a\u00020$2\u0006\u0010(\u001a\u00020)J\u0010\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020)H\u0002J\u0014\u00103\u001a\b\u0018\u00010\u0007R\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0006\u00104\u001a\u00020$J\u001c\u00105\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0+J\u0016\u00105\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\u001aJ\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020$H\u0002J\u0006\u0010:\u001a\u00020$R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\u0004\u00a8\u0006<"}, d2={"Lde/hglabor/utils/noriskutils/scoreboard/board/Board;", "", "updatingPeriod", "", "(J)V", "lines", "", "Lde/hglabor/utils/noriskutils/scoreboard/board/Board$BoardLine;", "getLines", "()Ljava/util/List;", "objective", "Lorg/bukkit/scoreboard/Objective;", "getObjective", "()Lorg/bukkit/scoreboard/Objective;", "runnable", "Lnet/axay/kspigot/runnables/KSpigotRunnable;", "getRunnable", "()Lnet/axay/kspigot/runnables/KSpigotRunnable;", "setRunnable", "(Lnet/axay/kspigot/runnables/KSpigotRunnable;)V", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "Lorg/jetbrains/annotations/NotNull;", "getScoreboard", "()Lorg/bukkit/scoreboard/Scoreboard;", "value", "", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "getUpdatingPeriod", "()J", "setUpdatingPeriod", "addFlag", "", "boardFlag", "Lde/hglabor/utils/noriskutils/scoreboard/board/BoardFlag;", "addLine", "line", "", "textCallback", "Lkotlin/Function0;", "boardLine", "text", "addLineBelow", "clear", "deleteLine", "entry", "index", "getLine", "resetBoard", "setLine", "setScoreboard", "player", "Lorg/bukkit/entity/Player;", "startRunnable", "updateBoard", "BoardLine", "hglabor-utils"})
public final class Board {
    private long updatingPeriod;
    @NotNull
    private final List<BoardLine> lines;
    @NotNull
    private String title;
    @NotNull
    private final Scoreboard scoreboard;
    @NotNull
    private final Objective objective;
    @Nullable
    private KSpigotRunnable runnable;

    public Board(long updatingPeriod) {
        this.updatingPeriod = updatingPeriod;
        this.lines = new ArrayList();
        this.title = "";
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"getScoreboardManager().newScoreboard");
        this.scoreboard = scoreboard;
        scoreboard = this.scoreboard.registerNewObjective("aaa", "bbb", this.title);
        Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"scoreboard.registerNewOb\u2026tive(\"aaa\", \"bbb\", title)");
        this.objective = scoreboard;
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.startRunnable();
    }

    public /* synthetic */ Board(long l, int i, DefaultConstructorMarker defaultConstructorMarker) {
        if ((i & 1) != 0) {
            l = 20L;
        }
        this(l);
    }

    public final long getUpdatingPeriod() {
        return this.updatingPeriod;
    }

    public final void setUpdatingPeriod(long l) {
        this.updatingPeriod = l;
    }

    @NotNull
    public final List<BoardLine> getLines() {
        return this.lines;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.title = value;
        this.objective.setDisplayName(value);
    }

    @NotNull
    public final Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    @NotNull
    public final Objective getObjective() {
        return this.objective;
    }

    @Nullable
    public final KSpigotRunnable getRunnable() {
        return this.runnable;
    }

    public final void setRunnable(@Nullable KSpigotRunnable kSpigotRunnable) {
        this.runnable = kSpigotRunnable;
    }

    private final void startRunnable() {
        KSpigotRunnablesKt.task$default((boolean)true, (long)20L, (Long)this.updatingPeriod, null, (boolean)false, null, (Function1)((Function1)new Function1<KSpigotRunnable, Unit>(this){
            final /* synthetic */ Board this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KSpigotRunnable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.updateBoard();
            }
        }), (int)56, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateBoard() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BoardLine it = (BoardLine)element$iv$iv;
            boolean i = false;
            if (!it.getShouldUpdate()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BoardLine it = (BoardLine)element$iv;
            boolean j = false;
            it.update();
        }
    }

    public final void resetBoard() {
        BoardLine it;
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (BoardLine)element$iv;
            boolean i = false;
            it.unregister();
        }
        $this$forEach$iv = this.lines;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (BoardLine)element$iv;
            boolean j = false;
            it.register();
        }
    }

    public final void addLine(int line, @NotNull BoardLine boardLine) {
        Intrinsics.checkNotNullParameter((Object)boardLine, (String)"boardLine");
        if (line == -1) {
            this.lines.add(boardLine);
            boardLine.register();
        } else {
            BoardLine it;
            Iterable $this$forEach$iv = this.lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (BoardLine)element$iv;
                boolean i = false;
                it.unregister();
            }
            this.lines.add(line, boardLine);
            $this$forEach$iv = this.lines;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (BoardLine)element$iv;
                boolean j = false;
                it.register();
            }
        }
    }

    public static /* synthetic */ void addLine$default(Board board, int i, BoardLine boardLine, int j, Object object) {
        if ((j & 1) != 0) {
            i = -1;
        }
        board.addLine(i, boardLine);
    }

    public final void addLine(int line, @NotNull Function0<String> textCallback) {
        Intrinsics.checkNotNullParameter(textCallback, (String)"textCallback");
        this.addLine(line, new BoardLine(textCallback));
    }

    public static /* synthetic */ void addLine$default(Board board, int i, Function0 function0, int j, Object object) {
        if ((j & 1) != 0) {
            i = -1;
        }
        board.addLine(i, (Function0<String>)function0);
    }

    public final void addLine(int line, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addLine(line, new BoardLine(text));
    }

    public static /* synthetic */ void addLine$default(Board board, int i, String string, int j, Object object) {
        if ((j & 1) != 0) {
            i = -1;
        }
        board.addLine(i, string);
    }

    public final void addLineBelow(@NotNull Function0<String> textCallback) {
        Intrinsics.checkNotNullParameter(textCallback, (String)"textCallback");
        this.addLine(0, new BoardLine(textCallback));
    }

    public final void addLineBelow(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addLine(0, new BoardLine(text));
    }

    @Nullable
    public final BoardLine getLine(int line) {
        return (BoardLine)CollectionsKt.getOrNull(this.lines, (int)line);
    }

    public final void setLine(int line, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        BoardLine boardLine = this.getLine(line);
        if (boardLine == null) {
            throw new IllegalStateException(("Line " + line + " not found!").toString());
        }
        BoardLine l = boardLine;
        l.setShouldUpdate(false);
        l.set(text);
    }

    public final void setLine(int line, @NotNull Function0<String> textCallback) {
        Intrinsics.checkNotNullParameter(textCallback, (String)"textCallback");
        BoardLine boardLine = this.getLine(line);
        if (boardLine == null) {
            throw new IllegalStateException(("Line " + line + " not found!").toString());
        }
        BoardLine l = boardLine;
        l.setShouldUpdate(true);
        l.set(textCallback);
    }

    public final void deleteLine(@NotNull BoardLine boardLine) {
        BoardLine boardLine2;
        Intrinsics.checkNotNullParameter((Object)boardLine, (String)"boardLine");
        ((Collection)this.lines).remove(boardLine);
        BoardLine $this$deleteLine_u24lambda_u2d6 = boardLine2 = boardLine;
        boolean i = false;
        $this$deleteLine_u24lambda_u2d6.setShouldUpdate(false);
        $this$deleteLine_u24lambda_u2d6.getTeam().unregister();
        this.getScoreboard().resetScores($this$deleteLine_u24lambda_u2d6.getEntry());
        this.resetBoard();
    }

    public final void deleteLine(int line) {
        this.deleteLine(this.lines.get(line));
    }

    public final void clear() {
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BoardLine it = (BoardLine)element$iv;
            boolean i = false;
            it.unregister();
        }
    }

    public final void addFlag(@NotNull BoardFlag boardFlag) {
        Intrinsics.checkNotNullParameter((Object)((Object)boardFlag), (String)"boardFlag");
        if (WhenMappings.$EnumSwitchMapping$0[boardFlag.ordinal()] == 1) {
            Objective objective;
            Objective $this$addFlag_u24lambda_u2d8 = objective = this.scoreboard.registerNewObjective("showhealth", "health", "health");
            boolean i = false;
            $this$addFlag_u24lambda_u2d8.setDisplaySlot(DisplaySlot.BELOW_NAME);
            $this$addFlag_u24lambda_u2d8.setDisplayName(ChatColor.RED + "\u2764");
            $this$addFlag_u24lambda_u2d8.getScore(String.valueOf(ChatColor.WHITE)).setScore(0);
        }
    }

    @NotNull
    public final Board setScoreboard(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.setScoreboard(this.scoreboard);
        return this;
    }

    private final String entry(int index) {
        return "" + ChatColor.values()[index] + ChatColor.WHITE;
    }

    public Board() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\u00020\u001f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fR\u001a\u0010\b\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\nR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lde/hglabor/utils/noriskutils/scoreboard/board/Board$BoardLine;", "", "text", "", "(Lde/hglabor/utils/noriskutils/scoreboard/board/Board;Ljava/lang/String;)V", "textCallback", "Lkotlin/Function0;", "(Lde/hglabor/utils/noriskutils/scoreboard/board/Board;Lkotlin/jvm/functions/Function0;)V", "entry", "getEntry", "()Ljava/lang/String;", "setEntry", "(Ljava/lang/String;)V", "shouldUpdate", "", "getShouldUpdate", "()Z", "setShouldUpdate", "(Z)V", "team", "Lorg/bukkit/scoreboard/Team;", "getTeam", "()Lorg/bukkit/scoreboard/Team;", "setTeam", "(Lorg/bukkit/scoreboard/Team;)V", "getText", "getTextCallback", "()Lkotlin/jvm/functions/Function0;", "setTextCallback", "(Lkotlin/jvm/functions/Function0;)V", "register", "", "set", "unregister", "update", "hglabor-utils"})
    public final class BoardLine {
        @NotNull
        private Function0<String> textCallback;
        private boolean shouldUpdate;
        @NotNull
        private Team team;
        public String entry;

        public BoardLine(Function0<String> textCallback) {
            Intrinsics.checkNotNullParameter((Object)Board.this, (String)"this$0");
            Intrinsics.checkNotNullParameter(textCallback, (String)"textCallback");
            this.textCallback = textCallback;
            this.shouldUpdate = true;
            Team team = Board.this.getScoreboard().getTeam("placeholder");
            if (team == null) {
                Team team2 = Board.this.getScoreboard().registerNewTeam("placeholder");
                Intrinsics.checkNotNullExpressionValue((Object)team2, (String)"scoreboard.registerNewTeam(\"placeholder\")");
                team = team2;
            }
            this.team = team;
        }

        @NotNull
        public final Function0<String> getTextCallback() {
            return this.textCallback;
        }

        public final void setTextCallback(@NotNull Function0<String> function0) {
            Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
            this.textCallback = function0;
        }

        public BoardLine(final String text) {
            Intrinsics.checkNotNullParameter((Object)Board.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this((Function0<String>)((Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return text;
                }
            }));
            this.shouldUpdate = false;
        }

        public final boolean getShouldUpdate() {
            return this.shouldUpdate;
        }

        public final void setShouldUpdate(boolean bl) {
            this.shouldUpdate = bl;
        }

        @NotNull
        public final Team getTeam() {
            return this.team;
        }

        public final void setTeam(@NotNull Team team) {
            Intrinsics.checkNotNullParameter((Object)team, (String)"<set-?>");
            this.team = team;
        }

        @NotNull
        public final String getEntry() {
            String string = this.entry;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"entry");
            return null;
        }

        public final void setEntry(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.entry = string;
        }

        public final void register() {
            int index = Board.this.getLines().indexOf(this);
            Team team = Board.this.getScoreboard().getTeam(String.valueOf(index));
            if (team == null) {
                Team team2 = Board.this.getScoreboard().registerNewTeam(String.valueOf(index));
                Intrinsics.checkNotNullExpressionValue((Object)team2, (String)"scoreboard.registerNewTeam(\"$index\")");
                team = team2;
            }
            this.team = team;
            this.setEntry(Board.this.entry(index));
            this.team.addEntry(this.getEntry());
            this.team.setPrefix(this.getText());
            Board.this.getObjective().getScore(this.getEntry()).setScore(index);
        }

        public final void unregister() {
            Board.this.getScoreboard().resetScores(this.getEntry());
        }

        public final void update() {
            this.team.setPrefix(this.getText());
        }

        public final void set(@NotNull Function0<String> textCallback) {
            Intrinsics.checkNotNullParameter(textCallback, (String)"textCallback");
            this.textCallback = textCallback;
            this.shouldUpdate = true;
        }

        public final void set(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.textCallback = (Function0)new Function0<String>(text){
                final /* synthetic */ String $text;
                {
                    this.$text = $text;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$text;
                }
            };
            this.shouldUpdate = false;
        }

        @NotNull
        public final String getText() {
            return (String)this.textCallback.invoke();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BoardFlag.values().length];
            nArray[BoardFlag.SHOW_HEALTH.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

