/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.pvpbots.goal;

import java.util.EnumSet;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.pathfinder.PathEntity;

public class PvPBotMeleeAttackGoal
extends PathfinderGoal {
    protected final EntityCreature mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private PathEntity path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

    public PvPBotMeleeAttackGoal(EntityCreature mob, double speed, boolean pauseWhenMobIdle) {
        this.mob = mob;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = pauseWhenMobIdle;
        this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
    }

    public boolean a() {
        long l = this.mob.t.getTime();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        EntityLiving livingEntity = this.mob.getGoalTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().a((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingEntity) >= this.mob.h(livingEntity.locX(), livingEntity.locY(), livingEntity.locZ());
    }

    public boolean b() {
        EntityLiving livingEntity = this.mob.getGoalTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.getNavigation().m();
        }
        if (!this.mob.a(livingEntity.getChunkCoordinates())) {
            return false;
        }
        return !(livingEntity instanceof EntityHuman) || !livingEntity.isSpectator() && !((EntityHuman)livingEntity).isCreative();
    }

    public void c() {
        this.mob.getNavigation().a(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void d() {
        EntityLiving livingEntity = this.mob.getGoalTarget();
        if (!IEntitySelector.e.test(livingEntity)) {
            this.mob.setGoalTarget((EntityLiving)null);
        }
        this.mob.setAggressive(false);
        this.mob.getNavigation().o();
    }

    public void e() {
        EntityLiving livingEntity = this.mob.getGoalTarget();
        this.mob.getControllerLook().a((Entity)livingEntity, 30.0f, 30.0f);
        double d = this.mob.h(livingEntity.locX(), livingEntity.locY(), livingEntity.locZ());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.getEntitySenses().a((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.h(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingEntity.locX();
            this.pathedTargetY = livingEntity.locY();
            this.pathedTargetZ = livingEntity.locZ();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
            if (d > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.getNavigation().a((Entity)livingEntity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingEntity, d);
    }

    protected void checkAndPerformAttack(EntityLiving target, double squaredDistance) {
        double d = this.getAttackReachSqr(target);
        if (squaredDistance <= d && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.swingHand(EnumHand.a);
            this.mob.attackEntity((Entity)target);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 0;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return 20;
    }

    protected double getAttackReachSqr(EntityLiving entity) {
        return this.mob.getWidth() * 2.0f * this.mob.getWidth() * 2.0f + entity.getWidth();
    }
}

