/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public final class WorldEditUtils {
    private WorldEditUtils() {
    }

    public static void pasteSchematic(World world, Location startLocation, File file) {
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        if (format == null) {
            return;
        }
        try {
            ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
            Clipboard clipboard = reader.read();
            WorldEditUtils.paste(world, startLocation, clipboard);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static void paste(World world, Location startLocation, Clipboard clipboard) {
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(BukkitAdapter.adapt((World)world), -1);){
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BukkitAdapter.asBlockVector((Location)startLocation)).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
        }
        catch (WorldEditException e) {
            e.printStackTrace();
        }
    }

    public static void createCylinder(World world, Location startLocation, int radius, boolean filled, int height, Material block) {
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(BukkitAdapter.adapt((World)world), -1);){
            editSession.setFastMode(true);
            editSession.makeCylinder(BukkitAdapter.asBlockVector((Location)startLocation), (Pattern)BukkitAdapter.asBlockState((ItemStack)new ItemStack(block)), (double)radius, height, filled);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

