/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import com.mojang.brigadier.StringReader;
import de.hglabor.utils.noriskutils.data.SimpleLoc;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.block.state.IBlockData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lde/hglabor/utils/noriskutils/SchematicReader;", "", "()V", "parseSchematic", "", "Lde/hglabor/utils/noriskutils/data/SimpleLoc;", "Lnet/minecraft/world/level/block/state/BlockState;", "inputStream", "Ljava/io/InputStream;", "ignoreAir", "", "hglabor-utils"})
public final class SchematicReader {
    @NotNull
    public static final SchematicReader INSTANCE = new SchematicReader();

    private SchematicReader() {
    }

    @NotNull
    public final Map<SimpleLoc, IBlockData> parseSchematic(@NotNull InputStream inputStream, boolean ignoreAir) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Map map = new LinkedHashMap();
        Map blockPalette = new LinkedHashMap();
        NBTTagCompound nbt = NBTCompressedStreamTools.a((InputStream)inputStream);
        int width = nbt.getInt("Width");
        int height = nbt.getInt("Height");
        int length = nbt.getInt("Length");
        byte[] blocks = nbt.getByteArray("BlockData");
        NBTTagCompound palette = nbt.getCompound("Palette");
        Set set2 = palette.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"palette.allKeys");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IBlockData state;
            String key = (String)element$iv;
            boolean j = false;
            if (new ArgumentBlock(new StringReader(key), true).a(true).getBlockData() == null) continue;
            Map map2 = blockPalette;
            Integer n = palette.getInt(key);
            map2.put(n, state);
        }
        Intrinsics.checkNotNullExpressionValue((Object)blocks, (String)"blocks");
        $this$forEach$iv = (Iterable)ArraysKt.getIndices((byte[])blocks);
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            IBlockData state;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean k = false;
            if ((IBlockData)blockPalette.get(blocks[i]) == null || ignoreAir && state.isAir()) continue;
            int x = i % (width * length) % width;
            int y = i / (width * length);
            int z = i % (width * length) / width;
            Map map3 = map;
            SimpleLoc simpleLoc = new SimpleLoc(x, y, z);
            map3.put(simpleLoc, state);
        }
        return map;
    }

    public static /* synthetic */ Map parseSchematic$default(SchematicReader schematicReader, InputStream inputStream, boolean bl, int i, Object object) {
        if ((i & 2) != 0) {
            bl = true;
        }
        return schematicReader.parseSchematic(inputStream, bl);
    }
}

