/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public final class RandomCollection<E> {
    private final NavigableMap<Double, E> map = new TreeMap<Double, E>();
    private final Map<E, String> names = new HashMap<E, String>();
    private final Random random = new Random();
    private double total = 0.0;

    public void add(double weight, E result) {
        if (weight <= 0.0) {
            return;
        }
        this.total += weight;
        this.map.put(this.total, result);
    }

    public void add(String name, double weight, E result) {
        if (weight <= 0.0) {
            return;
        }
        this.total += weight;
        this.map.put(this.total, result);
        this.names.put(result, name);
    }

    public String getName(E key) {
        return this.names.getOrDefault(key, "");
    }

    public E getRandom() {
        double value = this.random.nextDouble() * this.total;
        return this.map.higherEntry(value).getValue();
    }
}

