/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.pvpbots;

import de.hglabor.utils.noriskutils.NMSUtils;
import de.hglabor.utils.noriskutils.pvpbots.goal.PvPBotMeleeAttackGoal;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PvPBot
extends EntityZombie {
    public static final String META_DATA = "pvpBot";
    private final String name;
    private final PlayerDisguise playerDisguise;
    protected EntityLiving target;
    protected double attackRange = 10.0;
    private boolean isDefaultPathfinderTarget;

    public PvPBot(org.bukkit.World world, String name, Player player, JavaPlugin plugin) {
        this(world, name, NMSUtils.getEntityLiving((LivingEntity)player), plugin);
    }

    public PvPBot(org.bukkit.World world, String name, JavaPlugin plugin) {
        super((World)((CraftWorld)world).getHandle());
        this.name = name;
        this.t.addEntity((net.minecraft.world.entity.Entity)this);
        this.getEntity().setMetadata(META_DATA, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)""));
        this.getEntity().setShouldBurnInDay(false);
        this.getEntity().setRemoveWhenFarAway(false);
        this.setCustomName((IChatBaseComponent)new ChatComponentText(name));
        this.setCustomNameVisible(true);
        this.playerDisguise = new PlayerDisguise(name);
        this.playerDisguise.setNameVisible(true);
        this.playerDisguise.setDisplayedInTab(false);
        this.isDefaultPathfinderTarget = true;
        this.initPathfinder();
        DisguiseAPI.disguiseEntity((Entity)this.getBukkitEntity(), (Disguise)this.playerDisguise);
    }

    public PvPBot(org.bukkit.World world, String name, EntityLiving target, JavaPlugin plugin) {
        super((World)((CraftWorld)world).getHandle());
        this.name = name;
        this.target = target;
        this.t.addEntity((net.minecraft.world.entity.Entity)this);
        this.getEntity().setMetadata(META_DATA, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)""));
        this.getEntity().setShouldBurnInDay(false);
        this.getEntity().setRemoveWhenFarAway(false);
        this.setCustomName((IChatBaseComponent)new ChatComponentText(name));
        this.setCustomNameVisible(true);
        this.playerDisguise = new PlayerDisguise(name);
        this.playerDisguise.setNameVisible(true);
        DisguiseAPI.disguiseEntity((Entity)this.getBukkitEntity(), (Disguise)this.playerDisguise);
        this.setGoalTarget(target, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
    }

    public MinecraftKey getDefaultLootTable() {
        return null;
    }

    public void spawn(Location location) {
        this.setPosition(location.getX(), location.getY(), location.getZ());
    }

    public PvPBot withRange(double range) {
        this.attackRange = range * range;
        return this;
    }

    public PvPBot withItemInSlot(EquipmentSlot slot, ItemStack itemStack) {
        EntityEquipment equipment = this.getEntity().getEquipment();
        if (equipment != null) {
            equipment.setItem(slot, itemStack);
        }
        return this;
    }

    public PvPBot withMovementSpeed(double speed) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (attribute != null) {
            attribute.setBaseValue(speed);
        }
        return this;
    }

    public PvPBot withSkin(String skin) {
        this.playerDisguise.setSkin(skin);
        return this;
    }

    public PvPBot withDisplayInTab(boolean value) {
        this.playerDisguise.setDisplayedInTab(value);
        return this;
    }

    public PvPBot withFollowRange(double followRange) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_FOLLOW_RANGE);
        if (attribute != null) {
            attribute.setBaseValue(followRange);
        }
        return this;
    }

    public PvPBot withHealth(int health) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute != null) {
            attribute.setBaseValue((double)health);
        }
        this.setHealth(health);
        return this;
    }

    public PvPBot withDefaultPathfinderTarget(boolean value) {
        this.isDefaultPathfinderTarget = value;
        return this;
    }

    protected void initPathfinder() {
        this.bP.a(0, (PathfinderGoal)new PvPBotMeleeAttackGoal((EntityCreature)this, 1.0, false));
        if (this.isDefaultPathfinderTarget) {
            this.bP.a(5, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)this, EntityHuman.class, true));
        } else {
            this.bP.a(1, (PathfinderGoal)new PathfinderFindTarget());
        }
        this.bP.a(2, (PathfinderGoal)new PathfinderGoalFloat((EntityInsentient)this));
    }

    protected boolean isDropExperience() {
        return false;
    }

    protected SoundEffect getSoundHurt(DamageSource source) {
        return source == DamageSource.c ? SoundEffects.ow : (source == DamageSource.h ? SoundEffects.ou : (source == DamageSource.u ? SoundEffects.ox : (source == DamageSource.v ? SoundEffects.ov : SoundEffects.ot)));
    }

    public SoundEffect getSoundDeath() {
        return SoundEffects.os;
    }

    public Zombie getEntity() {
        return (Zombie)this.getBukkitEntity();
    }

    protected SoundEffect getSoundStep() {
        return SoundEffects.hK;
    }

    protected SoundEffect getSoundAmbient() {
        return null;
    }

    protected SoundEffect getSoundSwim() {
        return SoundEffects.oC;
    }

    protected SoundEffect getSoundSplash() {
        return SoundEffects.oA;
    }

    protected SoundEffect getSoundSplashHighSpeed() {
        return SoundEffects.oB;
    }

    protected SoundEffect getSoundFall(int distance) {
        return distance > 4 ? SoundEffects.op : SoundEffects.oz;
    }

    private class PathfinderFindTarget
    extends PathfinderGoal {
        private PathfinderFindTarget() {
        }

        public boolean a() {
            if (PvPBot.this.target == null) {
                return false;
            }
            PvPBot.this.setGoalTarget(PvPBot.this.target, EntityTargetEvent.TargetReason.CUSTOM, true);
            return true;
        }

        public void c() {
        }

        public boolean C_() {
            return false;
        }
    }
}

