/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.staffmode;

import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.staffmode.StaffPlayer;
import de.hglabor.utils.noriskutils.staffmode.StaffPlayerSupplier;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerHider
implements Listener {
    private final JavaPlugin plugin;
    private final StaffPlayerSupplier supplier;

    public PlayerHider(StaffPlayerSupplier supplier, JavaPlugin plugin) {
        this.supplier = supplier;
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        Player joined = event.getPlayer();
        StaffPlayer staffPlayer = this.supplier.getStaffPlayer(joined);
        if (staffPlayer.canSeeStaffModePlayers()) {
            return;
        }
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            StaffPlayer otherStaffPlayer = this.supplier.getStaffPlayer(otherPlayer);
            if (!otherStaffPlayer.isStaffMode() || otherStaffPlayer.isVisible()) continue;
            joined.hidePlayer((Plugin)this.plugin, otherPlayer);
        }
    }

    public void hide(Player playerToHide) {
        this.supplier.getStaffPlayer(playerToHide).setVisible(false);
        playerToHide.sendActionBar(Localization.INSTANCE.getMessage("staffmode.hidden", ChatUtils.locale(playerToHide)));
        for (Player player : Bukkit.getOnlinePlayers()) {
            StaffPlayer staffPlayer = this.supplier.getStaffPlayer(player);
            if (player.hasPermission("hglabor.staffmode") && (staffPlayer.canSeeStaffModePlayers() || staffPlayer.isStaffMode())) continue;
            player.hidePlayer((Plugin)this.plugin, playerToHide);
        }
    }

    public void show(Player playerToShow) {
        this.supplier.getStaffPlayer(playerToShow).setVisible(true);
        playerToShow.sendActionBar(Localization.INSTANCE.getMessage("staffmode.visible", ChatUtils.locale(playerToShow)));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.showPlayer((Plugin)this.plugin, playerToShow);
        }
    }

    public void hideEveryoneInStaffMode(Player player) {
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            StaffPlayer staffPlayer = this.supplier.getStaffPlayer(otherPlayer);
            if (!staffPlayer.isStaffMode()) continue;
            player.hidePlayer((Plugin)this.plugin, otherPlayer);
        }
    }

    public void showEveryoneInStaffMode(Player player) {
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            StaffPlayer staffPlayer = this.supplier.getStaffPlayer(otherPlayer);
            if (!staffPlayer.isStaffMode()) continue;
            player.showPlayer((Plugin)this.plugin, otherPlayer);
        }
    }

    public StaffPlayerSupplier getSupplier() {
        return this.supplier;
    }

    public void sendHideInformation() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            StaffPlayer staffPlayer = this.supplier.getStaffPlayer(player);
            if (!staffPlayer.isStaffMode()) continue;
            if (staffPlayer.isVisible()) {
                player.sendActionBar(Localization.INSTANCE.getMessage("staffmode.visible", ChatUtils.locale(player)));
                continue;
            }
            player.sendActionBar(Localization.INSTANCE.getMessage("staffmode.hidden", ChatUtils.locale(player)));
        }
    }
}

