/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.feast;

import com.google.common.collect.ImmutableMap;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.regions.CylinderRegion;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.RandomCollection;
import de.hglabor.utils.noriskutils.TimeConverter;
import de.hglabor.utils.noriskutils.WorldEditUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Feast
implements Listener {
    public static final String BLOCK_KEY = "FEAST_BLOCK";
    private static final Random random = new Random();
    private final Set<Block> feastBlocks;
    private final JavaPlugin plugin;
    private final World world;
    private final BossBar feastBossBar;
    private Location feastCenter;
    private Material platformMaterial;
    private int radius;
    private int timer;
    private int totalTime;
    private int airHeight;
    private int maxItemsInChest;
    private boolean inPreparation;
    private boolean isFinished;
    private boolean shouldDamageItems;

    public Feast(JavaPlugin plugin, World world) {
        this.plugin = plugin;
        this.world = world;
        this.feastBlocks = new HashSet<Block>();
        this.maxItemsInChest = 6;
        this.feastBossBar = Bukkit.createBossBar((String)"Feast", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
    }

    public Feast center(Location feastCenter) {
        this.feastCenter = feastCenter;
        return this;
    }

    public Feast material(Material platformMaterial) {
        this.platformMaterial = platformMaterial;
        return this;
    }

    public Feast radius(int radius) {
        this.radius = radius;
        return this;
    }

    public Feast timer(int timer) {
        this.timer = timer;
        this.totalTime = timer;
        return this;
    }

    public Feast maxItemsInChest(int maxItemsInChest) {
        this.maxItemsInChest = maxItemsInChest;
        return this;
    }

    public Feast air(int height) {
        this.airHeight = height;
        return this;
    }

    public Feast damageItems(boolean shouldDamage) {
        this.shouldDamageItems = shouldDamage;
        return this;
    }

    public void spawn() {
        this.inPreparation = true;
        Bukkit.getOnlinePlayers().forEach(player -> player.playSound(player.getLocation(), Sound.EVENT_RAID_HORN, 1.0f, 1.0f));
        WorldEditUtils.createCylinder(this.world, this.feastCenter, this.radius, true, 1, this.platformMaterial);
        WorldEditUtils.createCylinder(this.world, this.feastCenter.clone().add(0.0, 1.0, 0.0), this.radius, true, this.airHeight, Material.AIR);
        CylinderRegion cylinderRegion = new CylinderRegion(BukkitAdapter.adapt((World)this.world), BukkitAdapter.asBlockVector((Location)this.feastCenter), Vector2.at((double)this.radius, (double)this.radius), this.feastCenter.getBlockY(), this.feastCenter.getBlockY() + this.airHeight);
        for (BlockVector3 blockVector3 : cylinderRegion) {
            this.feastBlocks.add(this.world.getBlockAt(BukkitAdapter.adapt((World)this.world, (BlockVector3)blockVector3)));
        }
        this.feastBlocks.forEach(feastBlock -> feastBlock.setMetadata(BLOCK_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"")));
        this.startCountDown();
    }

    private void spawnFeastLoot() {
        this.feastCenter.clone().add(0.0, 1.0, 0.0).getBlock().setType(Material.ENCHANTING_TABLE);
        Location[] chestLocations = new Location[]{this.feastCenter.clone().add(1.0, 1.0, 1.0), this.feastCenter.clone().add(-1.0, 1.0, 1.0), this.feastCenter.clone().add(-1.0, 1.0, -1.0), this.feastCenter.clone().add(1.0, 1.0, -1.0), this.feastCenter.clone().add(2.0, 1.0, 2.0), this.feastCenter.clone().add(0.0, 1.0, 2.0), this.feastCenter.clone().add(-2.0, 1.0, 2.0), this.feastCenter.clone().add(2.0, 1.0, 0.0), this.feastCenter.clone().add(-2.0, 1.0, 0.0), this.feastCenter.clone().add(2.0, 1.0, -2.0), this.feastCenter.clone().add(0.0, 1.0, -2.0), this.feastCenter.clone().add(-2.0, 1.0, -2.0)};
        Arrays.stream(chestLocations).forEach(chestLocation -> chestLocation.getBlock().setType(Material.CHEST));
        RandomCollection<ItemStack> diamondItems = new RandomCollection<ItemStack>();
        diamondItems.add(1.0, new ItemStack(Material.DIAMOND_HELMET));
        diamondItems.add(1.0, new ItemStack(Material.DIAMOND_CHESTPLATE));
        diamondItems.add(1.0, new ItemStack(Material.DIAMOND_LEGGINGS));
        diamondItems.add(1.0, new ItemStack(Material.DIAMOND_BOOTS));
        diamondItems.add(1.0, new ItemStack(Material.DIAMOND_SWORD));
        RandomCollection<ItemStack> netheriteItems = new RandomCollection<ItemStack>();
        netheriteItems.add(1.0, new ItemStack(Material.NETHERITE_HELMET));
        netheriteItems.add(1.0, new ItemStack(Material.NETHERITE_CHESTPLATE));
        netheriteItems.add(1.0, new ItemStack(Material.NETHERITE_LEGGINGS));
        netheriteItems.add(1.0, new ItemStack(Material.NETHERITE_BOOTS));
        netheriteItems.add(1.0, new ItemStack(Material.NETHERITE_SWORD));
        RandomCollection<ItemStack> sizeableItems = new RandomCollection<ItemStack>();
        sizeableItems.add(1.0, new ItemStack(Material.SPECTRAL_ARROW));
        sizeableItems.add(1.0, new ItemStack(Material.LAPIS_LAZULI));
        sizeableItems.add(1.0, new ItemStack(Material.COOKED_BEEF));
        sizeableItems.add(1.0, new ItemStack(Material.COOKED_PORKCHOP));
        sizeableItems.add(1.0, new ItemStack(Material.COOKED_CHICKEN));
        sizeableItems.add(1.0, new ItemStack(Material.MUSHROOM_STEW));
        RandomCollection<ItemStack> singleItems = new RandomCollection<ItemStack>();
        singleItems.add(1.0, new ItemStack(Material.BOW));
        singleItems.add(1.0, new ItemStack(Material.COBWEB));
        singleItems.add(1.0, new ItemStack(Material.FLINT_AND_STEEL));
        singleItems.add(1.0, new ItemStack(Material.TNT));
        singleItems.add(1.0, new ItemStack(Material.ENDER_PEARL));
        singleItems.add(1.0, new ItemStack(Material.LAVA_BUCKET));
        singleItems.add(1.0, new ItemStack(Material.WATER_BUCKET));
        RandomCollection<RandomCollection<ItemStack>> lootPool = new RandomCollection<RandomCollection<ItemStack>>();
        lootPool.add(20.0, diamondItems);
        lootPool.add(33.0, sizeableItems);
        lootPool.add(33.0, singleItems);
        lootPool.add(3.0, netheriteItems);
        for (Location chestLocation2 : chestLocations) {
            Chest chest = (Chest)chestLocation2.getBlock().getState();
            for (int i = 0; i < this.maxItemsInChest; ++i) {
                RandomCollection randomItemCollection = (RandomCollection)lootPool.getRandom();
                ItemStack item = (ItemStack)randomItemCollection.getRandom();
                if (randomItemCollection.equals(sizeableItems)) {
                    item.setAmount(random.nextInt(10) + 1);
                }
                if (this.shouldDamageItems && (randomItemCollection.equals(netheriteItems) || randomItemCollection.equals(diamondItems))) {
                    Damageable damageable = (Damageable)item.getItemMeta();
                    short maxDurability = item.getType().getMaxDurability();
                    damageable.setDamage(maxDurability - random.nextInt(maxDurability / 4));
                    item.setItemMeta((ItemMeta)damageable);
                }
                chest.getInventory().setItem(random.nextInt(25) + 1, item);
            }
        }
    }

    private void startCountDown() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (!Feast.this.feastBossBar.getPlayers().contains(player)) {
                        Feast.this.feastBossBar.addPlayer(player);
                    }
                });
                Feast.this.feastBossBar.setTitle(Localization.INSTANCE.getMessage("feast.broadcastMessage", (Map)ImmutableMap.of((Object)"centerLocation", (Object)Feast.this.printFeastCenter(), (Object)"timeString", (Object)TimeConverter.stringify(Feast.this.timer)), Locale.ENGLISH));
                Feast.this.feastBossBar.setProgress((double)Feast.this.timer / (double)Feast.this.totalTime);
                if (Feast.this.timer % 60 == 0 || Feast.this.timer < 10) {
                    ChatUtils.broadcastMessage("feast.broadcastMessage", (Map<String, String>)ImmutableMap.of((Object)"centerLocation", (Object)Feast.this.printFeastCenter(), (Object)"timeString", (Object)TimeConverter.stringify(Feast.this.timer)));
                }
                --Feast.this.timer;
                if (Feast.this.timer <= 0) {
                    Feast.this.inPreparation = false;
                    Feast.this.isFinished = true;
                    Feast.this.feastBossBar.removeAll();
                    Feast.this.feastBlocks.forEach(feastBlock -> feastBlock.removeMetadata(Feast.BLOCK_KEY, (Plugin)Feast.this.plugin));
                    Feast.this.spawnFeastLoot();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public String printFeastCenter() {
        return "[" + (int)this.feastCenter.getX() + ", " + (int)this.feastCenter.getY() + ", " + (int)this.feastCenter.getZ() + "]";
    }
}

