/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils.pvpbots;

import de.hglabor.utils.noriskutils.NMSUtils;
import java.util.EnumSet;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import net.minecraft.server.v1_16_R3.ChatComponentText;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityZombie;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IEntitySelector;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.PathEntity;
import net.minecraft.server.v1_16_R3.PathfinderGoal;
import net.minecraft.server.v1_16_R3.PathfinderGoalFloat;
import net.minecraft.server.v1_16_R3.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.v1_16_R3.SoundCategory;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.SoundEffects;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PvPBot
extends EntityZombie {
    public static final String META_DATA = "pvpBot";
    private final String name;
    private final PlayerDisguise playerDisguise;
    protected EntityLiving target;
    protected double attackRange = 10.0;
    private boolean isDefaultPathfinderTarget;

    public PvPBot(org.bukkit.World world, String name, Player player, JavaPlugin plugin) {
        this(world, name, NMSUtils.getEntityLiving((LivingEntity)player), plugin);
    }

    public PvPBot(org.bukkit.World world, String name, JavaPlugin plugin) {
        super((World)((CraftWorld)world).getHandle());
        this.name = name;
        this.getWorld().addEntity((net.minecraft.server.v1_16_R3.Entity)this);
        this.getEntity().setMetadata(META_DATA, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)""));
        this.getEntity().setShouldBurnInDay(false);
        this.getEntity().setRemoveWhenFarAway(false);
        this.setCustomName((IChatBaseComponent)new ChatComponentText(name));
        this.setCustomNameVisible(true);
        this.playerDisguise = new PlayerDisguise(name);
        this.playerDisguise.setNameVisible(true);
        this.playerDisguise.setDisplayedInTab(false);
        this.isDefaultPathfinderTarget = true;
        this.initPathfinder();
        DisguiseAPI.disguiseEntity((Entity)this.getBukkitEntity(), (Disguise)this.playerDisguise);
    }

    public PvPBot(org.bukkit.World world, String name, EntityLiving target, JavaPlugin plugin) {
        super((World)((CraftWorld)world).getHandle());
        this.name = name;
        this.target = target;
        this.getWorld().addEntity((net.minecraft.server.v1_16_R3.Entity)this);
        this.getEntity().setMetadata(META_DATA, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)""));
        this.getEntity().setShouldBurnInDay(false);
        this.getEntity().setRemoveWhenFarAway(false);
        this.setCustomName((IChatBaseComponent)new ChatComponentText(name));
        this.setCustomNameVisible(true);
        this.playerDisguise = new PlayerDisguise(name);
        this.playerDisguise.setNameVisible(true);
        DisguiseAPI.disguiseEntity((Entity)this.getBukkitEntity(), (Disguise)this.playerDisguise);
        this.setGoalTarget(target, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
    }

    public void die(DamageSource damagesource) {
        super.die(damagesource);
    }

    public MinecraftKey getLootTable() {
        return null;
    }

    protected MinecraftKey getDefaultLootTable() {
        return null;
    }

    public void spawn(Location location) {
        this.setPosition(location.getX(), location.getY(), location.getZ());
    }

    public PvPBot withRange(double range) {
        this.attackRange = range * range;
        return this;
    }

    public PvPBot withItemInSlot(EquipmentSlot slot, ItemStack itemStack) {
        EntityEquipment equipment = this.getEntity().getEquipment();
        if (equipment != null) {
            equipment.setItem(slot, itemStack);
        }
        return this;
    }

    public PvPBot withMovementSpeed(double speed) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (attribute != null) {
            attribute.setBaseValue(speed);
        }
        return this;
    }

    public PvPBot withSkin(String skin) {
        this.playerDisguise.setSkin(skin);
        return this;
    }

    public PvPBot withDisplayInTab(boolean value) {
        this.playerDisguise.setDisplayedInTab(value);
        return this;
    }

    public PvPBot withFollowRange(double followRange) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_FOLLOW_RANGE);
        if (attribute != null) {
            attribute.setBaseValue(followRange);
        }
        return this;
    }

    public PvPBot withHealth(int health) {
        AttributeInstance attribute = this.craftAttributes.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute != null) {
            attribute.setBaseValue((double)health);
        }
        this.setHealth(health);
        return this;
    }

    public PvPBot withDefaultPathfinderTarget(boolean value) {
        this.isDefaultPathfinderTarget = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    protected void initPathfinder() {
        this.goalSelector.a(0, (PathfinderGoal)new PathfinderGoalMeleeAttack(1.0));
        if (this.isDefaultPathfinderTarget) {
            this.goalSelector.a(5, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)this, EntityHuman.class, true));
        } else {
            this.goalSelector.a(1, (PathfinderGoal)new PathfinderFindTarget());
        }
        this.goalSelector.a(2, (PathfinderGoal)new PathfinderGoalFloat((EntityInsentient)this));
    }

    protected boolean isDropExperience() {
        return false;
    }

    protected SoundEffect getSoundHurt(DamageSource damagesource) {
        return damagesource == DamageSource.BURN ? SoundEffects.ENTITY_PLAYER_HURT_ON_FIRE : (damagesource == DamageSource.DROWN ? SoundEffects.ENTITY_PLAYER_HURT_DROWN : (damagesource == DamageSource.SWEET_BERRY_BUSH ? SoundEffects.ENTITY_PLAYER_HURT_SWEET_BERRY_BUSH : SoundEffects.ENTITY_PLAYER_HURT));
    }

    public Zombie getEntity() {
        return (Zombie)this.getBukkitEntity();
    }

    protected SoundEffect getSoundDeath() {
        return SoundEffects.ENTITY_PLAYER_DEATH;
    }

    protected SoundEffect getSoundStep() {
        return SoundEffects.BLOCK_GRASS_STEP;
    }

    protected SoundEffect getSoundAmbient() {
        return null;
    }

    protected SoundEffect getSoundFall(int i) {
        return i > 4 ? SoundEffects.ENTITY_PLAYER_BIG_FALL : SoundEffects.ENTITY_PLAYER_SMALL_FALL;
    }

    protected SoundEffect getSoundSwim() {
        return SoundEffects.ENTITY_PLAYER_SWIM;
    }

    protected SoundEffect getSoundSplash() {
        return SoundEffects.ENTITY_PLAYER_SPLASH;
    }

    protected SoundEffect getSoundSplashHighSpeed() {
        return SoundEffects.ENTITY_PLAYER_SPLASH_HIGH_SPEED;
    }

    public SoundCategory getSoundCategory() {
        return SoundCategory.PLAYERS;
    }

    private class PathfinderFindTarget
    extends PathfinderGoal {
        private PathfinderFindTarget() {
        }

        public boolean a() {
            if (PvPBot.this.target == null) {
                return false;
            }
            PvPBot.this.setGoalTarget(PvPBot.this.target, EntityTargetEvent.TargetReason.CUSTOM, true);
            return true;
        }

        public void e() {
        }

        public boolean b() {
            return false;
        }
    }

    private class PathfinderGoalMeleeAttack
    extends PathfinderGoal {
        private final double b;
        private final boolean c;
        private PathEntity pathEntity;
        private double e;
        private double f;
        private double g;
        private int h;
        private int attackCooldown;
        private long k;

        public PathfinderGoalMeleeAttack(double var1) {
            this.b = var1;
            this.c = true;
            this.a(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        public boolean a() {
            long var0 = PvPBot.this.world.getTime();
            if (var0 - this.k < 20L) {
                return false;
            }
            this.k = var0;
            EntityLiving var2 = PvPBot.this.getGoalTarget();
            if (var2 == null) {
                return false;
            }
            if (!var2.isAlive()) {
                return false;
            }
            this.pathEntity = PvPBot.this.getNavigation().a((net.minecraft.server.v1_16_R3.Entity)var2, 0);
            if (this.pathEntity != null) {
                return true;
            }
            return this.attackEntity(var2) >= PvPBot.this.h(var2.locX(), var2.locY(), var2.locZ());
        }

        public boolean b() {
            EntityLiving var0 = PvPBot.this.getGoalTarget();
            if (var0 == null) {
                return false;
            }
            if (!var0.isAlive()) {
                return false;
            }
            if (!this.c) {
                return !PvPBot.this.getNavigation().m();
            }
            if (!PvPBot.this.a(var0.getChunkCoordinates())) {
                return false;
            }
            return !(var0 instanceof EntityHuman) || !var0.isSpectator() && !((EntityHuman)var0).isCreative();
        }

        public void c() {
            PvPBot.this.getNavigation().a(this.pathEntity, this.b);
            PvPBot.this.setAggressive(true);
            this.h = 0;
            this.attackCooldown = 0;
        }

        public void d() {
            EntityLiving var0 = PvPBot.this.getGoalTarget();
            if (!IEntitySelector.e.test(var0)) {
                PvPBot.this.setGoalTarget(null);
            }
            PvPBot.this.setAggressive(false);
            PvPBot.this.getNavigation().o();
        }

        public void e() {
            EntityLiving target = PvPBot.this.getGoalTarget();
            PvPBot.this.getControllerLook().a((net.minecraft.server.v1_16_R3.Entity)target, 30.0f, 30.0f);
            double distanceToTarget = PvPBot.this.h(target.locX(), target.locY(), target.locZ());
            this.h = Math.max(this.h - 1, 0);
            if ((this.c || PvPBot.this.getEntitySenses().a((net.minecraft.server.v1_16_R3.Entity)target)) && this.h <= 0 && (this.e == 0.0 && this.f == 0.0 && this.g == 0.0 || target.h(this.e, this.f, this.g) >= 1.0 || PvPBot.this.getRandom().nextFloat() < 0.05f)) {
                this.e = target.locX();
                this.f = target.locY();
                this.g = target.locZ();
                this.h = 4 + PvPBot.this.getRandom().nextInt(7);
                if (distanceToTarget > 1024.0) {
                    this.h += 10;
                } else if (distanceToTarget > 256.0) {
                    this.h += 5;
                }
                if (!PvPBot.this.getNavigation().a((net.minecraft.server.v1_16_R3.Entity)target, this.b)) {
                    this.h += 15;
                }
            }
            this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
            this.attackEntity(target, distanceToTarget);
        }

        protected void attackEntity(EntityLiving target, double distanceToTarget) {
            if (distanceToTarget <= PvPBot.this.attackRange && this.attackCooldown <= 0) {
                this.resetAttackCooldown();
                PvPBot.this.swingHand(EnumHand.MAIN_HAND);
                PvPBot.this.attackEntity((net.minecraft.server.v1_16_R3.Entity)target);
            }
        }

        protected void resetAttackCooldown() {
            this.attackCooldown = 0;
        }

        protected double attackEntity(EntityLiving var0) {
            return PvPBot.this.getWidth() * 2.0f * PvPBot.this.getWidth() * 2.0f + var0.getWidth();
        }
    }
}

