/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public final class JedisUtils {
    public static final String GLOBALCHAT_ENABLE_CHANNEL = "globalchat-enable";
    public static final String GLOBALCHAT_DISABLE_CHANNEL = "globalchat-disable";
    public static final String CUSTOMCHAT_ENABLE_CHANNEL = "customchat-enable";
    public static final String CUSTOMCHAT_DISABLE_CHANNEL = "customchat-disable";
    private static JedisPool jedisPool;

    private JedisUtils() {
    }

    public static void init(String password) {
        jedisPool = new JedisPool((GenericObjectPoolConfig)JedisUtils.buildPoolConfig(), "localhost", 6379, 2000, password);
    }

    private static JedisPoolConfig buildPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(128);
        poolConfig.setMaxIdle(128);
        poolConfig.setMinIdle(16);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setMinEvictableIdleTimeMillis(Duration.ofSeconds(60L).toMillis());
        poolConfig.setTimeBetweenEvictionRunsMillis(Duration.ofSeconds(30L).toMillis());
        poolConfig.setNumTestsPerEvictionRun(3);
        poolConfig.setBlockWhenExhausted(true);
        return poolConfig;
    }

    public static void subscribe(JedisPubSub channel, String ... channels) {
        CompletableFuture.runAsync(() -> {
            try (Jedis jedis = jedisPool.getResource();){
                jedis.subscribe(channel, channels);
            }
        });
    }

    public static void publish(String channel, String message) {
        CompletableFuture.runAsync(() -> {
            try (Jedis jedis = jedisPool.getResource();){
                jedis.publish(channel, message);
            }
        });
    }

    public static void closePool() {
        jedisPool.close();
    }
}

