/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta itemMeta;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.itemMeta = this.item.getItemMeta();
    }

    public ItemBuilder(ItemStack itemStack) {
        this.item = itemStack;
        this.itemMeta = this.item.getItemMeta();
    }

    public ItemBuilder setName(String name) {
        this.itemMeta.setDisplayName(name);
        return this;
    }

    public ItemBuilder setPlayerSkull(String name) {
        SkullMeta skullMeta = (SkullMeta)this.itemMeta;
        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        return this;
    }

    public ItemBuilder setTitle(String name) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.setTitle(name);
        return this;
    }

    public ItemBuilder addPage(String text) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.addPage(new String[]{text});
        return this;
    }

    public ItemBuilder setAuthor(String author) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.setAuthor(author);
        return this;
    }

    public ItemBuilder setPage(int page, String text) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.setPage(page, text);
        return this;
    }

    public ItemBuilder setDescription(String ... lore) {
        this.itemMeta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder addLore(String ... lore) {
        ArrayList<String> text = new ArrayList<String>();
        text.addAll(Objects.requireNonNull(this.itemMeta.getLore()));
        text.addAll(Arrays.asList(lore));
        this.itemMeta.setLore(text);
        return this;
    }

    public ItemBuilder setPotionEffect(PotionEffectType potionEffect, Color color) {
        PotionMeta potionMeta = (PotionMeta)this.itemMeta;
        potionMeta.setColor(color);
        potionMeta.addCustomEffect(new PotionEffect(potionEffect, 0, 0), true);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.itemMeta.setUnbreakable(unbreakable);
        return this;
    }

    public ItemBuilder setEnchantment(Enchantment enchantment, int lvl) {
        this.itemMeta.addEnchant(enchantment, lvl, true);
        return this;
    }

    public ItemBuilder hideItemFlags() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        return this;
    }

    public ItemBuilder hideEnchants() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return this;
    }

    public ItemBuilder setLocalizedName(String name) {
        this.itemMeta.setLocalizedName(name);
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.itemMeta);
        return this.item;
    }
}

