/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.noriskutils;

import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkSection;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;

public final class BlockPlacer {
    public static void setBlockInNativeWorld(World world, int x, int y, int z, Material material, boolean applyPhysics) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        BlockPosition bp = new BlockPosition(x, y, z);
        Block block = CraftMagicNumbers.getBlock((Material)material);
        nmsWorld.setTypeAndData(bp, block.getBlockData(), applyPhysics ? 3 : 2);
    }

    public static void setBlockInNativeChunk(World world, int x, int y, int z, Material material, boolean applyPhysics) {
        try {
            WorldServer nmsWorld = ((CraftWorld)world).getHandle();
            Chunk nmsChunk = nmsWorld.getChunkAt(x >> 4, z >> 4);
            BlockPosition bp = new BlockPosition(x, y, z);
            Block block = CraftMagicNumbers.getBlock((Material)material);
            nmsChunk.setType(bp, block.getBlockData(), applyPhysics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setBlockInNativeChunkSection(World world, int x, int y, int z, Material material) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        Chunk nmsChunk = nmsWorld.getChunkAt(x >> 4, z >> 4);
        Block block = CraftMagicNumbers.getBlock((Material)material);
        ChunkSection cs = nmsChunk.getSections()[y >> 4];
        if (cs == nmsChunk.a()) {
            nmsChunk.getSections()[y >> 4] = cs = new ChunkSection(y >> 4 << 4);
        }
        cs.setType(x & 0xF, y & 0xF, z & 0xF, block.getBlockData());
    }

    public static void setBlockInNativeDataPalette(World world, int x, int y, int z, Material material, boolean applyPhysics) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        Chunk nmsChunk = nmsWorld.getChunkAt(x >> 4, z >> 4);
        Block block = CraftMagicNumbers.getBlock((Material)material);
        ChunkSection cs = nmsChunk.getSections()[y >> 4];
        if (cs == nmsChunk.a()) {
            nmsChunk.getSections()[y >> 4] = cs = new ChunkSection(y >> 4 << 4);
        }
        if (applyPhysics) {
            cs.getBlocks().setBlock(x & 0xF, y & 0xF, z & 0xF, (Object)block.getBlockData());
        } else {
            cs.getBlocks().b(x & 0xF, y & 0xF, z & 0xF, (Object)block.getBlockData());
        }
    }
}

