/*
 * Decompiled with CFR 0.152.
 */
package de.helwich.junit;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JasmineReporter {
    private RunNotifier notifier;
    private List<Description> descriptionStack;
    private int descriptionStackIndex;

    public void jasmineStarted(int totalSpecsDefined) {
        Description desc = this.descriptionStack.get(this.descriptionStackIndex++);
        this.notifier.fireTestStarted(desc);
    }

    public void jasmineDone() {
        Description desc = this.descriptionStack.remove(--this.descriptionStackIndex);
        this.notifier.fireTestFinished(desc);
        this.descriptionStack = null;
    }

    public void suiteStarted(String id, String description, String fullName, String status) {
        Description desc;
        if (!description.equals((desc = this.descriptionStack.get(this.descriptionStackIndex++)).getDisplayName()) || !desc.isSuite()) {
            throw new RuntimeException("unexpected suite description");
        }
        this.notifier.fireTestStarted(desc);
    }

    public void suiteDone(String id, String description, String fullName, String status) {
        Description desc;
        if (!description.equals((desc = this.descriptionStack.remove(--this.descriptionStackIndex)).getDisplayName()) || !desc.isSuite()) {
            throw new RuntimeException("unexpected suite description");
        }
        this.notifier.fireTestFinished(desc);
    }

    public void specStarted(String id, String description, String fullName, String[] failedExpectations) {
        Description desc = this.descriptionStack.get(this.descriptionStackIndex);
        if (!(description + "()").equals(desc.getDisplayName()) || !desc.isTest()) {
            throw new RuntimeException("unexpected test description");
        }
        this.notifier.fireTestStarted(desc);
    }

    public void specDone(String id, String description, String fullName, String[] failedExpectations, String status) {
        Description desc = this.descriptionStack.remove(this.descriptionStackIndex);
        if (!(description + "()").equals(desc.getDisplayName()) || !desc.isTest()) {
            throw new RuntimeException("unexpected test description");
        }
        if ("failed".equals(status)) {
            this.notifier.fireTestFailure(new Failure(desc, null));
        } else if ("pending".equals(status)) {
            this.notifier.fireTestIgnored(desc);
        } else {
            this.notifier.fireTestFinished(desc);
        }
    }

    public void setNotifier(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public void setDescription(Description description) {
        this.descriptionStack = new ArrayList<Description>();
        this.traverse(this.descriptionStack, description);
        this.descriptionStackIndex = 0;
    }

    private void traverse(List<Description> descriptionStack, Description description) {
        descriptionStack.add(description);
        for (Description desc : description.getChildren()) {
            this.traverse(descriptionStack, desc);
        }
    }
}

