/*
 * Decompiled with CFR 0.152.
 */
package de.helwich.junit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;

public class JasmineDescriber {
    private final List<Description> descStack = new ArrayList<Description>();
    private boolean disabled = false;
    private static int descId = 1;

    private void pushDescription(Description desc) {
        this.checkEnabled();
        Description top = this.descStack.get(this.descStack.size() - 1);
        top.addChild(desc);
        this.descStack.add(desc);
    }

    private Description popDescription() {
        this.checkEnabled();
        return this.descStack.remove(this.descStack.size() - 1);
    }

    private void checkEnabled() {
        if (this.disabled) {
            throw new RuntimeException("describer used at an unexpected time");
        }
    }

    public void describeStart(String description) {
        this.pushDescription(Description.createSuiteDescription((String)description, (Serializable)Integer.valueOf(descId++), (Annotation[])new Annotation[0]));
    }

    public void describeEnd() {
        this.popDescription();
    }

    public void testStart(String description) {
        this.pushDescription(Description.createTestDescription((String)"", (String)description, (Serializable)Integer.valueOf(descId++)));
        this.popDescription();
    }

    public Description getDescription() {
        if (this.descStack.size() != 1) {
            throw new RuntimeException("unexpected description state");
        }
        return this.popDescription();
    }

    public void disable() {
        this.disabled = true;
    }

    public void setRootName(String name) {
        if (this.descStack.size() != 0) {
            throw new RuntimeException("root description name must be set exactly one time at init time");
        }
        this.descStack.add(Description.createSuiteDescription((String)name, (Serializable)Integer.valueOf(descId++), (Annotation[])new Annotation[0]));
    }
}

