/*
 * Decompiled with CFR 0.152.
 */
package de.helwich.junit;

import de.helwich.junit.JasmineDescriber;
import de.helwich.junit.JasmineReporter;
import de.helwich.junit.JasmineTest;
import java.io.File;
import java.net.URL;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class JasmineTestRunner
extends Runner {
    private final JasmineTest info;
    private final Class<?> testClass;
    private final ScriptEngine nashorn;
    private final JasmineReporter reporter;
    private final Description description;

    public JasmineTestRunner(Class<?> testClass) {
        try {
            this.testClass = testClass;
            this.info = testClass.getAnnotation(JasmineTest.class);
            if (this.info == null) {
                throw new RuntimeException("annotation " + JasmineTest.class.getName() + " is missing on class " + testClass.getName());
            }
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            this.nashorn = scriptEngineManager.getEngineByName("nashorn");
            if (this.nashorn == null) {
                throw new RuntimeException("please use java 8");
            }
            if (this.info.browser()) {
                this.evalResource(this.nashorn, "/envjs/env.js");
            } else {
                this.evalResource(this.nashorn, "/de/helwich/junit/timer.js");
            }
            this.evalResource(this.nashorn, "/jasmine/jasmine.js");
            this.evalResource(this.nashorn, "/jasmine/boot.js");
            JasmineDescriber describer = (JasmineDescriber)this.nashorn.eval("jasmine.junitDescriber = new (Java.type(\"" + JasmineDescriber.class.getName() + "\")); ");
            describer.setRootName(testClass.getName());
            this.evalResource(this.nashorn, "/de/helwich/junit/describer.js");
            for (String src : this.info.src()) {
                this.evalFile(this.nashorn, this.info.srcDir() + "/" + src + this.info.fileSuffix());
            }
            for (String test : this.info.test()) {
                this.evalFile(this.nashorn, this.info.testDir() + "/" + test + this.info.fileSuffix());
            }
            this.description = describer.getDescription();
            describer.disable();
            this.reporter = (JasmineReporter)this.nashorn.eval("jasmine.junitReporter = new (Java.type(\"" + JasmineReporter.class.getName() + "\")); ");
            this.reporter.setDescription(this.description);
            this.evalResource(this.nashorn, "/de/helwich/junit/reporter.js");
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public Description getDescription() {
        return this.description;
    }

    private File projectDir() {
        String relPath = this.testClass.getProtectionDomain().getCodeSource().getLocation().getFile();
        File targetDir = new File(relPath + "../../");
        return targetDir;
    }

    private final Object evalResource(ScriptEngine nashorn, String name) {
        URL url = this.testClass.getResource(name);
        String src = url.toExternalForm();
        try {
            return nashorn.eval("load('" + src + "')");
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private final Object evalFile(ScriptEngine nashorn, String name) {
        File file = new File(this.projectDir(), name);
        String src = file.getAbsolutePath();
        try {
            return nashorn.eval("load('" + src + "')");
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public void run(RunNotifier notifier) {
        try {
            this.runThrows(notifier);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public void runThrows(RunNotifier notifier) throws ScriptException {
        this.reporter.setNotifier(notifier);
        this.nashorn.eval("jasmine.getEnv().execute();");
        if (this.info.browser()) {
            this.nashorn.eval("Envjs.wait()");
        } else {
            this.nashorn.eval("setTimeout.wait()");
        }
    }
}

