/*
 * Decompiled with CFR 0.152.
 */
package de.hegmanns.test.utils.rules.consoleredirect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConsoleRedirectRule
implements TestRule {
    private ConsoleRedirectStatement consoleRedirectStatement = new ConsoleRedirectStatement();

    public static ConsoleRedirectRule instance() {
        return new ConsoleRedirectRule();
    }

    public Statement apply(Statement baseStatement, Description description) {
        return this.consoleRedirectStatement;
    }

    public String getOutput() {
        if (this.consoleRedirectStatement.testOutputString != null) {
            return this.consoleRedirectStatement.testOutputString;
        }
        String output = new String(this.consoleRedirectStatement.byteArrayOutputStream.toByteArray());
        return output;
    }

    private class ConsoleRedirectStatement
    extends Statement {
        private PrintStream realPrintStream = null;
        private PrintStream testPrintStream = null;
        private ByteArrayOutputStream byteArrayOutputStream = null;
        private String testOutputString = null;
        private Statement statement;

        private ConsoleRedirectStatement() {
        }

        public void evaluate() throws Throwable {
            this.realPrintStream = System.out;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.testPrintStream = new PrintStream(this.byteArrayOutputStream);
            System.setOut(this.testPrintStream);
            try {
                this.statement.evaluate();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.testOutputString = new String(this.byteArrayOutputStream.toByteArray());
                System.setOut(this.realPrintStream);
                this.testPrintStream.close();
                try {
                    this.byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

