/*
 * Decompiled with CFR 0.152.
 */
package de.hegmanns.test.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;

public class SerializationTestHelper {
    public static SerialationTestResult serializeIntoStream(Object instance, ObjectOutputStream outputStream) {
        SerialationTestResult result = SerialationTestResult.OK;
        try {
            outputStream.writeObject(instance);
        }
        catch (InvalidClassException e) {
            result = SerialationTestResult.ERROR_INVALID_CLASS;
        }
        catch (NotSerializableException e) {
            result = SerialationTestResult.ERROR_NOT_SERIALIZABLE;
        }
        catch (IOException e) {
            result = SerialationTestResult.ERROR_IO;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SerialationTestResult checkSerialize(Object instance) {
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new ByteArrayOutputStream());){
            SerialationTestResult serialationTestResult = SerializationTestHelper.serializeIntoStream(instance, outputStream);
            return serialationTestResult;
        }
        catch (IOException e) {
            return SerialationTestResult.ERROR_TECHNICAL;
        }
    }

    public static enum SerialationTestResult {
        OK,
        ERROR_NOT_SERIALIZABLE,
        ERROR_IO,
        ERROR_INVALID_CLASS,
        ERROR_TECHNICAL;

    }
}

