/*
 * Decompiled with CFR 0.152.
 */
package de.hdi.mongobumblebee.utils;

import de.hdi.mongobumblebee.changeset.ChangeEntry;
import de.hdi.mongobumblebee.changeset.ChangeLog;
import de.hdi.mongobumblebee.changeset.ChangeSet;
import de.hdi.mongobumblebee.exception.MongoBumblebeeChangeSetException;
import de.hdi.mongobumblebee.utils.ChangeLogComparator;
import de.hdi.mongobumblebee.utils.ChangeSetComparator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.context.annotation.Profile;
import org.springframework.lang.NonNull;

public class ChangeService {
    public static final String DEFAULT_PROFILE = "default";
    private final String changeLogsBasePackage;
    private final List<String> activeProfiles;

    public ChangeService(String changeLogsBasePackage) {
        this(changeLogsBasePackage, List.of(DEFAULT_PROFILE));
    }

    public ChangeService(String changeLogsBasePackage, @NonNull List<String> activeProfiles) {
        this.changeLogsBasePackage = changeLogsBasePackage;
        this.activeProfiles = activeProfiles;
    }

    public List<Class<?>> fetchChangeLogs() {
        ConfigurationBuilder configuration = new ConfigurationBuilder().forPackages(new String[]{this.changeLogsBasePackage}).setInputsFilter(s -> s.contains(this.changeLogsBasePackage));
        Reflections reflections = new Reflections((Configuration)configuration);
        Set changeLogs = reflections.getTypesAnnotatedWith(ChangeLog.class);
        List<Class<?>> filteredChangeLogs = this.filterByActiveProfiles(changeLogs);
        Collections.sort(filteredChangeLogs, new ChangeLogComparator());
        return filteredChangeLogs;
    }

    public List<Method> fetchChangeSets(Class<?> type) throws MongoBumblebeeChangeSetException {
        List<Method> changeSets = this.filterChangeSetAnnotation(Arrays.asList(type.getDeclaredMethods()));
        List<Method> filteredChangeSets = this.filterByActiveProfiles(changeSets);
        Collections.sort(filteredChangeSets, new ChangeSetComparator());
        return filteredChangeSets;
    }

    public boolean isRunAlwaysChangeSet(Method changesetMethod) {
        if (changesetMethod.isAnnotationPresent(ChangeSet.class)) {
            ChangeSet annotation = changesetMethod.getAnnotation(ChangeSet.class);
            return annotation.runAlways();
        }
        return false;
    }

    public ChangeEntry createChangeEntry(Method changesetMethod) {
        if (changesetMethod.isAnnotationPresent(ChangeSet.class)) {
            ChangeSet annotation = changesetMethod.getAnnotation(ChangeSet.class);
            return new ChangeEntry(annotation.id(), annotation.author(), new Date(), changesetMethod.getDeclaringClass().getName(), changesetMethod.getName(), null);
        }
        return null;
    }

    private boolean matchesActiveSpringProfile(AnnotatedElement element) {
        if (!this.isPresent(Profile.class.getName())) {
            return true;
        }
        if (!element.isAnnotationPresent(Profile.class)) {
            return true;
        }
        List<String> profiles = Arrays.asList(element.getAnnotation(Profile.class).value());
        for (String profile : profiles) {
            if (!(profile != null && profile.length() > 0 && profile.charAt(0) == '!' ? !this.activeProfiles.contains(profile.substring(1)) : this.activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }

    private <T extends AnnotatedElement> List<T> filterByActiveProfiles(Collection<T> annotated) {
        ArrayList<AnnotatedElement> filtered = new ArrayList<AnnotatedElement>();
        for (AnnotatedElement element : annotated) {
            if (!this.matchesActiveSpringProfile(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    private List<Method> filterChangeSetAnnotation(List<Method> allMethods) throws MongoBumblebeeChangeSetException {
        HashSet<String> changeSetIds = new HashSet<String>();
        ArrayList<Method> changesetMethods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!method.isAnnotationPresent(ChangeSet.class)) continue;
            String id = method.getAnnotation(ChangeSet.class).id();
            if (changeSetIds.contains(id)) {
                throw new MongoBumblebeeChangeSetException(String.format("Duplicated changeset id found: '%s'", id));
            }
            changeSetIds.add(id);
            changesetMethods.add(method);
        }
        return changesetMethods;
    }

    private boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

