/*
 * Decompiled with CFR 0.152.
 */
package de.hdi.mongobumblebee.dao;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockDao {
    private static final Logger log = LoggerFactory.getLogger(LockDao.class);
    private static final String KEY_PROP_NAME = "key";
    private static final String LOCK_ENTRY_KEY_VAL = "LOCK";
    private static final int INDEX_SORT_ASC = 1;
    private String lockCollectionName;

    public LockDao(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }

    public void intitializeLock(MongoDatabase db) {
        this.createCollectionAndUniqueIndexIfNotExists(db);
    }

    private void createCollectionAndUniqueIndexIfNotExists(MongoDatabase db) {
        Document indexKeys = new Document(KEY_PROP_NAME, (Object)1);
        IndexOptions indexOptions = new IndexOptions().unique(true).name("mbblock_key_idx");
        db.getCollection(this.lockCollectionName).createIndex((Bson)indexKeys, indexOptions);
    }

    public boolean acquireLock(MongoDatabase db) {
        Document insertObj = new Document(KEY_PROP_NAME, (Object)LOCK_ENTRY_KEY_VAL).append("status", (Object)"LOCK_HELD").append("lastAccess", (Object)LocalDateTime.now());
        try {
            db.getCollection(this.lockCollectionName).insertOne((Object)insertObj);
        }
        catch (MongoWriteException ex) {
            if (ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                log.warn("Duplicate key exception while acquireLock. Probably the lock has been already acquired by another process.");
            }
            return false;
        }
        return true;
    }

    public void updateLock(MongoDatabase db) {
        Bson filter = Filters.eq((String)"status", (Object)"LOCK_HELD");
        Bson update = Updates.set((String)"lastAccess", (Object)LocalDateTime.now());
        UpdateResult result = db.getCollection(this.lockCollectionName).updateOne(filter, update);
        if (result.getModifiedCount() != 1L) {
            log.warn("Lock couldn't be updated");
        }
    }

    public void releaseLock(MongoDatabase db) {
        db.getCollection(this.lockCollectionName).deleteMany((Bson)new Document(KEY_PROP_NAME, (Object)LOCK_ENTRY_KEY_VAL));
    }

    public boolean isLockHeld(MongoDatabase db) {
        return db.getCollection(this.lockCollectionName).countDocuments() == 1L;
    }

    public LocalDateTime getLastAccess(MongoDatabase db) {
        Document doc = (Document)db.getCollection(this.lockCollectionName).find().first();
        if (doc != null) {
            Date dateToConvert = (Date)doc.get((Object)"lastAccess", Date.class);
            return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        return null;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }
}

