/*
 * Decompiled with CFR 0.152.
 */
package de.hdi.mongobumblebee;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import de.hdi.mongobumblebee.changeset.ChangeEntry;
import de.hdi.mongobumblebee.dao.ChangeEntryDao;
import de.hdi.mongobumblebee.exception.MongoBumblebeeChangeSetException;
import de.hdi.mongobumblebee.exception.MongoBumblebeeConfigurationException;
import de.hdi.mongobumblebee.exception.MongoBumblebeeConnectionException;
import de.hdi.mongobumblebee.exception.MongoBumblebeeException;
import de.hdi.mongobumblebee.utils.ChangeService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class MongoBumblebee
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MongoBumblebee.class);
    public static final String MB_PREFIX = "mbb";
    public static final boolean DEFAULT_WAIT_FOR_LOCK = false;
    public static final long DEFAULT_CHANGE_LOG_LOCK_WAIT_TIME = 5L;
    public static final long DEFAULT_CHANGE_LOG_LOCK_POLL_RATE = 10L;
    public static final boolean DEFAULT_THROW_EXCEPTION_IF_CANNOT_OBTAIN_LOCK = false;
    private static final String DEFAULT_CHANGELOG_COLLECTION_NAME = "mbbchangelog";
    private static final String DEFAULT_LOCK_COLLECTION_NAME = "mbblock";
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    private ChangeEntryDao dao;
    private boolean enabled = true;
    private String changeLogsScanPackage;
    private final MongoClient mongoClient;
    private final String dbName;
    private Environment springEnvironment;

    public MongoBumblebee(@NonNull MongoClient mongoClient, @NonNull String dbName) {
        this.dbName = dbName;
        this.mongoClient = mongoClient;
        this.dao = new ChangeEntryDao(DEFAULT_CHANGELOG_COLLECTION_NAME, DEFAULT_LOCK_COLLECTION_NAME, false, 5L, 10L, false);
    }

    public MongoBumblebee(@NonNull String mongoURI, @NonNull String dbName) {
        this(MongoClients.create((String)mongoURI), dbName);
    }

    public void afterPropertiesSet() throws Exception {
        this.execute();
    }

    public void execute() throws MongoBumblebeeException {
        if (!this.isEnabled()) {
            log.info("MongoBumblebee is disabled. Exiting.");
            return;
        }
        this.validateConfig();
        if (this.mongoClient != null) {
            this.dao.connectMongoDb(this.mongoClient, this.dbName);
        }
        if (!this.dao.acquireProcessLock()) {
            log.info("MongoBumblebee did not acquire process lock. Exiting.");
            return;
        }
        log.info("MongoBumblebee acquired process lock, starting the data migration sequence..");
        try {
            this.executeMigration();
        }
        finally {
            log.info("MongoBumblebee is releasing process lock.");
            this.dao.releaseProcessLock();
        }
        log.info("MongoBumblebee has finished his job.");
    }

    private void executeMigration() throws MongoBumblebeeException {
        List<String> activeProfiles;
        if (this.springEnvironment != null && this.springEnvironment.getActiveProfiles() != null && this.springEnvironment.getActiveProfiles().length > 0) {
            activeProfiles = Arrays.asList(this.springEnvironment.getActiveProfiles());
        } else {
            log.info("default'used as profile because no environment was set");
            activeProfiles = Arrays.asList("default");
        }
        ChangeService service = new ChangeService(this.changeLogsScanPackage, activeProfiles);
        for (Class<?> changelogClass : service.fetchChangeLogs()) {
            Object changelogInstance = null;
            try {
                try {
                    changelogInstance = changelogClass.getDeclaredConstructor(ApplicationContext.class).newInstance(this.applicationContext);
                }
                catch (NoSuchMethodException e) {
                    changelogInstance = changelogClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                List<Method> changesetMethods = service.fetchChangeSets(changelogInstance.getClass());
                for (Method changesetMethod : changesetMethods) {
                    ChangeEntry changeEntry = service.createChangeEntry(changesetMethod);
                    try {
                        if (this.dao.isNewChange(changeEntry)) {
                            result = this.executeChangeSetMethod(changesetMethod, changelogInstance, this.dao.getMongoDatabase());
                            changeEntry.setResult(result);
                            this.dao.save(changeEntry);
                            log.info(changeEntry + " applied. Return= " + result);
                        } else if (service.isRunAlwaysChangeSet(changesetMethod)) {
                            result = this.executeChangeSetMethod(changesetMethod, changelogInstance, this.dao.getMongoDatabase());
                            changeEntry.setResult(result);
                            this.dao.save(changeEntry);
                            log.info(changeEntry + " reapplied. Return= " + result);
                        } else {
                            log.info(changeEntry + " passed over");
                        }
                        this.dao.updateLock();
                    }
                    catch (MongoBumblebeeChangeSetException e) {
                        log.error(e.getMessage());
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new MongoBumblebeeException(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw new MongoBumblebeeException(targetException.getMessage(), e);
            }
        }
    }

    private Object executeChangeSetMethod(Method changeSetMethod, Object changeLogInstance, MongoDatabase mongoDatabase) throws IllegalAccessException, InvocationTargetException, MongoBumblebeeChangeSetException {
        if (changeSetMethod.getParameterTypes().length == 1 && changeSetMethod.getParameterTypes()[0].equals(MongoTemplate.class)) {
            log.debug("method with MongoTemplate argument");
            return changeSetMethod.invoke(changeLogInstance, new MongoTemplate(this.mongoClient, this.dbName));
        }
        if (changeSetMethod.getParameterTypes().length == 2 && changeSetMethod.getParameterTypes()[0].equals(MongoTemplate.class) && changeSetMethod.getParameterTypes()[1].equals(Environment.class)) {
            log.debug("method with MongoTemplate and environment arguments");
            return changeSetMethod.invoke(changeLogInstance, new MongoTemplate(this.mongoClient, this.dbName), this.springEnvironment);
        }
        if (changeSetMethod.getParameterTypes().length == 1 && changeSetMethod.getParameterTypes()[0].equals(MongoDatabase.class)) {
            log.debug("method with DB argument");
            return changeSetMethod.invoke(changeLogInstance, mongoDatabase);
        }
        if (changeSetMethod.getParameterTypes().length == 0) {
            log.debug("method with no params");
            return changeSetMethod.invoke(changeLogInstance, new Object[0]);
        }
        throw new MongoBumblebeeChangeSetException("ChangeSet method " + changeSetMethod.getName() + " has wrong arguments list. Please see docs for more info!");
    }

    private void validateConfig() throws MongoBumblebeeConfigurationException {
        if (!StringUtils.hasText((String)this.dbName)) {
            throw new MongoBumblebeeConfigurationException("DB name is not set. It should be defined in MongoDB URI");
        }
        if (!StringUtils.hasText((String)this.changeLogsScanPackage)) {
            throw new MongoBumblebeeConfigurationException("Scan package for changelogs is not set: use appropriate setter");
        }
    }

    public boolean isExecutionInProgress() throws MongoBumblebeeConnectionException {
        return this.dao.isProccessLockHeld();
    }

    public MongoBumblebee setChangeLogsScanPackage(String changeLogsScanPackage) {
        this.changeLogsScanPackage = changeLogsScanPackage;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MongoBumblebee setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MongoBumblebee setWaitForLock(boolean waitForLock) {
        this.dao.setWaitForLock(waitForLock);
        return this;
    }

    public MongoBumblebee setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.dao.setChangeLogLockWaitTime(changeLogLockWaitTime);
        return this;
    }

    public MongoBumblebee setChangeLogLockPollRate(long changeLogLockPollRate) {
        this.dao.setChangeLogLockPollRate(changeLogLockPollRate);
        return this;
    }

    public MongoBumblebee setThrowExceptionIfCannotObtainLock(boolean throwExceptionIfCannotObtainLock) {
        this.dao.setThrowExceptionIfCannotObtainLock(throwExceptionIfCannotObtainLock);
        return this;
    }

    public MongoBumblebee setSpringEnvironment(Environment environment) {
        this.springEnvironment = environment;
        return this;
    }

    public MongoBumblebee setChangelogCollectionName(String changelogCollectionName) {
        this.dao.setChangelogCollectionName(changelogCollectionName);
        return this;
    }

    public MongoBumblebee setLockCollectionName(String lockCollectionName) {
        this.dao.setLockCollectionName(lockCollectionName);
        return this;
    }

    public void close() {
        this.dao.close();
    }
}

