/*
 * Decompiled with CFR 0.152.
 */
package de.hashcode.validation;

import de.hashcode.validation.EntityManagerAwareValidator;
import de.hashcode.validation.ReflectionUtils;
import de.hashcode.validation.UniqueKey;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UniqueKeyValidator
implements ConstraintValidator<UniqueKey, Serializable>,
EntityManagerAwareValidator {
    private EntityManager entityManager;
    private UniqueKey constraintAnnotation;

    public UniqueKeyValidator() {
    }

    public UniqueKeyValidator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void initialize(UniqueKey constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }

    public boolean isValid(Serializable target, ConstraintValidatorContext context) {
        if (this.entityManager == null) {
            return true;
        }
        Class<?> entityClass = target.getClass();
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery();
        Root root = criteriaQuery.from(entityClass);
        try {
            Object propertyValue = ReflectionUtils.getPropertyValue(target, this.constraintAnnotation.property());
            Predicate uniquePropertyPredicate = criteriaBuilder.equal((Expression)root.get(this.constraintAnnotation.property()), propertyValue);
            Field idField = ReflectionUtils.getIdField(entityClass);
            String idProperty = idField.getName();
            Object idValue = ReflectionUtils.getPropertyValue(target, idProperty);
            if (idValue != null) {
                Predicate idNotEqualsPredicate = criteriaBuilder.notEqual((Expression)root.get(idProperty), idValue);
                criteriaQuery.where(new Predicate[]{uniquePropertyPredicate, idNotEqualsPredicate});
            } else {
                criteriaQuery.where((Expression)uniquePropertyPredicate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred when trying to create the jpa predicate for the @UniqueKey '" + this.constraintAnnotation.property() + "' on bean " + entityClass + ".", e);
        }
        List resultSet = this.entityManager.createQuery(criteriaQuery).getResultList();
        if (!resultSet.isEmpty()) {
            context.buildConstraintViolationWithTemplate(this.constraintAnnotation.message()).addNode(this.constraintAnnotation.property()).addConstraintViolation().disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }
}

