/*
 * Decompiled with CFR 0.152.
 */
package de.hashcode.validation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.persistence.Id;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Field getIdField(Class<?> entityClass) throws IllegalArgumentException {
        Field[] fields;
        for (Field field : fields = entityClass.getDeclaredFields()) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return field;
        }
        if (entityClass.getSuperclass() != Object.class) {
            return ReflectionUtils.getIdField(entityClass.getSuperclass());
        }
        throw new IllegalArgumentException("No id field found on class " + entityClass);
    }

    @CheckForNull
    public static Object getPropertyValue(@Nonnull Object object, @Nonnull String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = ReflectionUtils.getGetter(object.getClass(), propertyName);
        return method.invoke(object, (Object[])null);
    }

    @Nonnull
    private static String toMethodName(@Nonnull String methodPrefix, @Nonnull String propertyName) {
        return methodPrefix + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    @Nonnull
    private static Method getGetter(@Nonnull Class<?> clazz, @Nonnull String property) {
        Method getter;
        String get = ReflectionUtils.toMethodName("get", property);
        String is = ReflectionUtils.toMethodName("is", property);
        try {
            getter = clazz.getMethod(get, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                getter = clazz.getMethod(is, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Getter for '" + clazz.getSimpleName() + '#' + property + "' not found.", noSuchMethodException2);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException("Method '" + clazz.getSimpleName() + '#' + is + "()' is protected by the security manager.");
            }
        }
        catch (SecurityException securityException) {
            try {
                getter = clazz.getMethod(is, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Method '" + clazz.getSimpleName() + '#' + get + "()' is protected by the security manager.");
            }
            catch (SecurityException securityException2) {
                throw new RuntimeException("Methods '" + clazz.getSimpleName() + '#' + get + "()' and " + clazz.getSimpleName() + '#' + is + "()' are protected by the security manager.");
            }
        }
        return getter;
    }
}

