/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.processes.threading;

import de.halcony.processes.threading.ThreadManager;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import wvlet.log.LogLevel;

public class ThreadManagerBuilder<T> {
    private final ThreadManager<T> threadManager = new ThreadManager();

    public ThreadManagerBuilder(Function1<T, BoxedUnit> lambda) {
        this.processingLambda(lambda);
    }

    private ThreadManagerBuilder<T> processingLambda(Function1<T, BoxedUnit> lambda) {
        this.threadManager.setLambda(lambda);
        return this;
    }

    public ThreadManagerBuilder<T> setLogLevel(LogLevel level) {
        this.threadManager.setLogLevel(level);
        return this;
    }

    public ThreadManagerBuilder<T> addJob(T job) {
        this.threadManager.addJob(job);
        return this;
    }

    public ThreadManagerBuilder<T> addJobs(Seq<T> jobs) {
        this.threadManager.addJobs(jobs);
        return this;
    }

    public ThreadManagerBuilder<T> threadCount(int count) {
        this.threadManager.setThreadCount(count);
        return this;
    }

    public ThreadManagerBuilder<T> handleErrors(Function2<Option<T>, Throwable, Option<Tuple2<Option<T>, Throwable>>> onError) {
        this.threadManager.setOnError(onError);
        return this;
    }

    public ThreadManager<T> create() {
        return this.threadManager.createPool();
    }

    public ThreadManager<T> start() {
        return this.create().start();
    }
}

