/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.processes.threading;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;

public class ThreadManager<T>
implements LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ThreadManager.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private Option<Function1<T, BoxedUnit>> lambda;
    private final ListBuffer<Tuple2<Option<T>, Throwable>> errors;
    private Function2<Option<T>, Throwable, Option<Tuple2<Option<T>, Throwable>>> onError;
    private boolean threadsShallBeRunning;
    private int threadCount;
    private final Queue<T> jobQueue;
    private final Map<Object, Thread> threads;
    private final Map<Object, Option<T>> threadsJob;

    public ThreadManager() {
        this.logger().setLogLevel((LogLevel)LogLevel.ERROR$.MODULE$);
        this.lambda = None$.MODULE$;
        this.errors = new ListBuffer();
        this.onError = (Function2 & Serializable)(input, thr) -> {
            block0: {
                ThreadManager LoggingMethods_this = this;
                if (!LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) break block0;
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().logWithCause((LogLevel)LogLevel.ERROR$.MODULE$, LogSource$.MODULE$.apply("", "ThreadManager.scala", 43, 63), (Object)new StringBuilder(33).append("unhandled error while processing ").append(input).toString(), thr);
            }
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(input, thr));
        };
        this.threadsShallBeRunning = true;
        this.threadCount = Runtime.getRuntime().availableProcessors();
        this.jobQueue = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.threads = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.threadsJob = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setLogLevel(LogLevel level) {
        this.logger().setLogLevel(level);
    }

    public void setLambda(Function1<T, BoxedUnit> lambda) {
        this.lambda = Some$.MODULE$.apply(lambda);
    }

    public Seq<Tuple2<Option<T>, Throwable>> getErrors() {
        List list;
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            list = this.errors.toList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<Option<T>, Throwable>> resetErrors() {
        void var2_3;
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            void var3_2;
            Seq<Tuple2<Option<T>, Throwable>> ret = this.getErrors();
            this.errors.clear();
            var2_3 = var3_2;
        }
        return var2_3;
    }

    public ThreadManager<T> setOnError(Function2<Option<T>, Throwable, Option<Tuple2<Option<T>, Throwable>>> onError) {
        this.onError = onError;
        return this;
    }

    private void encounteredError(Option<T> input, Throwable thr) {
        Option option = (Option)this.onError.apply(input, (Object)thr);
        if (option instanceof Some) {
            Tuple2 err = (Tuple2)((Some)option).value();
            ThreadManager threadManager = this;
            synchronized (threadManager) {
                this.errors.addOne((Object)err);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private boolean getKeepRunning() {
        boolean bl;
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            bl = this.threadsShallBeRunning;
        }
        return bl;
    }

    public ThreadManager<T> setThreadCount(int count) {
        ThreadManager threadManager;
        ThreadManager threadManager2 = this;
        synchronized (threadManager2) {
            this.threadCount = count;
            threadManager = this;
        }
        return threadManager;
    }

    public void addJob(T job) {
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            this.jobQueue.addOne(job);
            this.notifyAll();
        }
    }

    public void addJobs(Seq<T> jobs) {
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            this.jobQueue.addAll(jobs);
            this.notifyAll();
        }
    }

    public int remainingJobs() {
        int n;
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            n = this.jobQueue.length();
        }
        return n;
    }

    private boolean areThreadsAlive() {
        return this.threads.values().exists((Function1 & Serializable)_$1 -> _$1.isAlive());
    }

    private Map<Object, Option<T>> setThreadJob(int id, Option<T> job) {
        Map map;
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            map = (Map)this.threadsJob.addOne((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)id), job));
        }
        return map;
    }

    public scala.collection.immutable.Map<Object, Option<T>> getThreadJobs() {
        scala.collection.immutable.Map map;
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            map = this.threadsJob.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return map;
    }

    public ThreadManager<T> createPool() {
        ThreadManager parentManager = this;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.threadCount).foreach((Function1 & Serializable)id -> this.createPool$$anonfun$1(parentManager, BoxesRunTime.unboxToInt((Object)id)));
        return this;
    }

    public ThreadManager<T> start() {
        this.threads.values().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.start());
        return this;
    }

    public boolean stop(long gracePeriodMs) {
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            this.threadsShallBeRunning = false;
            this.notifyAll();
        }
        long start = System.currentTimeMillis();
        return ((IterableOnceOps)this.threads.values().map((Function1 & Serializable)thread -> {
            long delta = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)new .colon.colon((Object)BoxesRunTime.boxToLong((long)(start + gracePeriodMs - System.currentTimeMillis())), (List)new .colon.colon((Object)BoxesRunTime.boxToLong((long)0L), (List)Nil$.MODULE$))).max((Ordering)Ordering.Long$.MODULE$));
            thread.join(delta);
            return thread.isAlive();
        })).exists((Function1 & Serializable)x -> ThreadManager.stop$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)x)));
    }

    public long stop$default$1() {
        return 100L;
    }

    public boolean isAlive() {
        return this.areThreadsAlive();
    }

    public void destroy() {
        this.threads.values().foreach((Function1)(JProcedure1 & Serializable)thread -> thread.interrupt());
    }

    public boolean waitFor(long timeoutMs) {
        long start = System.currentTimeMillis();
        long delta = start + timeoutMs - System.currentTimeMillis();
        while (this.areThreadsAlive() && delta > 0L) {
            delta = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)new .colon.colon((Object)BoxesRunTime.boxToLong((long)(start + timeoutMs - System.currentTimeMillis())), (List)new .colon.colon((Object)BoxesRunTime.boxToLong((long)0L), (List)Nil$.MODULE$))).max((Ordering)Ordering.Long$.MODULE$));
            ThreadManager LoggingMethods_this = this;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "ThreadManager.scala", 215, 33), (Object)new StringBuilder(12).append("waiting for ").append(delta).toString());
            }
            ThreadManager threadManager = this;
            synchronized (threadManager) {
                BoxedUnit boxedUnit;
                if (delta > 0L) {
                    this.wait(delta);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return this.jobQueue.isEmpty();
    }

    private final /* synthetic */ Map createPool$$anonfun$1(ThreadManager parentManager$2, int id) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id));
        return (Map)this.threads.addOne((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)new Thread(() -> {
            int myId = id;
            ThreadManager LoggingMethods_this = parentManager$2;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "ThreadManager.scala", 112, 55), (Object)new StringBuilder(19).append("thread ").append(myId).append(" has started").toString());
            }
            try {
                try {
                    while (parentManager$2.getKeepRunning()) {
                        None$ none$;
                        ThreadManager threadManager = parentManager$2;
                        synchronized (threadManager) {
                            None$ none$2;
                            if (this.jobQueue.isEmpty()) {
                                this.wait();
                                none$2 = None$.MODULE$;
                            } else {
                                none$2 = Some$.MODULE$.apply(this.jobQueue.dequeue());
                            }
                            none$ = none$2;
                        }
                        None$ none$3 = none$;
                        if (none$3 instanceof Some) {
                            Object job = ((Some)none$3).value();
                            try {
                                try {
                                    ThreadManager LoggingMethods_this2 = parentManager$2;
                                    if (LoggingMethods_this2.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                                        LoggingMethods_this2.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "ThreadManager.scala", 125, 80), (Object)new StringBuilder(30).append("thread ").append(myId).append(" starts processing job ").append(job).toString());
                                    }
                                    this.setThreadJob(myId, (Option<T>)Some$.MODULE$.apply(job));
                                    ((Function1)this.lambda.get()).apply(job);
                                }
                                catch (Throwable thr) {
                                    parentManager$2.encounteredError((Option<T>)Some$.MODULE$.apply(job), thr);
                                }
                            }
                            catch (Throwable throwable) {
                                this.setThreadJob(myId, (Option<T>)None$.MODULE$);
                                ThreadManager threadManager2 = parentManager$2;
                                synchronized (threadManager2) {
                                    parentManager$2.notifyAll();
                                }
                                throw throwable;
                            }
                            this.setThreadJob(myId, (Option<T>)None$.MODULE$);
                            ThreadManager threadManager3 = parentManager$2;
                            synchronized (threadManager3) {
                                parentManager$2.notifyAll();
                                continue;
                            }
                        }
                        if (None$.MODULE$.equals(none$3)) continue;
                        throw new MatchError((Object)none$3);
                    }
                }
                catch (Throwable thr) {
                    parentManager$2.encounteredError((Option<T>)None$.MODULE$, thr);
                }
            }
            catch (Throwable throwable) {
                ThreadManager LoggingMethods_this3 = parentManager$2;
                if (LoggingMethods_this3.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                    LoggingMethods_this3.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "ThreadManager.scala", 145, 53), (Object)new StringBuilder(15).append("thread ").append(myId).append(" is done").toString());
                }
                ThreadManager threadManager = parentManager$2;
                synchronized (threadManager) {
                    parentManager$2.notifyAll();
                }
                throw throwable;
            }
            ThreadManager LoggingMethods_this4 = parentManager$2;
            if (LoggingMethods_this4.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                LoggingMethods_this4.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "ThreadManager.scala", 145, 53), (Object)new StringBuilder(15).append("thread ").append(myId).append(" is done").toString());
            }
            ThreadManager threadManager = parentManager$2;
            synchronized (threadManager) {
                parentManager$2.notifyAll();
            }
        })));
    }

    private static final /* synthetic */ boolean stop$$anonfun$2(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }
}

