/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.processes.cmd;

import de.halcony.processes.cmd.CmdProcess;
import java.io.File;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Arrays$;
import wvlet.log.LogLevel;

public class CmdProcessBuilder {
    private final ProcessBuilder builder;
    private final CmdProcess processWrapper;
    private boolean isStdOutSet;
    private boolean isStdErrSet;

    public CmdProcessBuilder(Seq<String> cmd) {
        this.builder = new ProcessBuilder((String[])Arrays$.MODULE$.seqToArray(cmd, String.class));
        this.processWrapper = new CmdProcess();
        this.isStdOutSet = false;
        this.isStdErrSet = false;
    }

    private void stdOutSet() {
        if (this.isStdOutSet) {
            throw new RuntimeException("stdout handling already defined");
        }
        this.isStdOutSet = true;
    }

    private void stdErrSet() {
        if (this.isStdErrSet) {
            throw new RuntimeException("stderr handling already defined");
        }
        this.isStdErrSet = true;
    }

    public CmdProcessBuilder directory(File folder) {
        if (!folder.isDirectory()) {
            throw new RuntimeException(new java.lang.StringBuilder(38).append("the provided path is not a directory: ").append(folder.getAbsolutePath()).toString());
        }
        this.builder.directory(folder);
        return this;
    }

    public CmdProcessBuilder collectStdOut(File collector) {
        this.stdOutSet();
        this.builder.redirectOutput(collector);
        return this;
    }

    public CmdProcessBuilder collectStdOut() {
        StringBuilder sb = new StringBuilder();
        return this.collectStdOut(sb);
    }

    public CmdProcessBuilder collectStdOut(StringBuilder collector) {
        this.stdOutSet();
        this.processWrapper.setStdoutCollector(collector);
        return this;
    }

    public CmdProcessBuilder discardStdOut() {
        this.stdOutSet();
        this.builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        return this;
    }

    public CmdProcessBuilder collectStdErr(File collector) {
        this.stdErrSet();
        this.builder.redirectError(collector);
        return this;
    }

    public CmdProcessBuilder collectStdErr() {
        StringBuilder sb = new StringBuilder();
        return this.collectStdErr(sb);
    }

    public CmdProcessBuilder collectStdErr(StringBuilder collector) {
        this.stdErrSet();
        this.processWrapper.setStderrCollector(collector);
        return this;
    }

    public CmdProcessBuilder discardStdErr() {
        this.stdErrSet();
        this.builder.redirectError(ProcessBuilder.Redirect.DISCARD);
        return this;
    }

    public CmdProcessBuilder setLogLevel(LogLevel level) {
        this.processWrapper.setLogLevel(level);
        return this;
    }

    public CmdProcess start() {
        if (!this.isStdOutSet) {
            this.collectStdOut();
        }
        if (!this.isStdErrSet) {
            this.collectStdErr();
        }
        return this.processWrapper.start(this.builder.start());
    }
}

