/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.processes.cmd;

import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class CmdProcess
implements LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CmdProcess.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final int READ_BUFFER_SIZE;
    private Option<Process> wrappedProcess;
    private boolean shallBeAlive;
    private Option<StringBuilder> stdoutCollector;
    private Option<Thread> stdoutCollectorThread;
    private Option<Exception> stdoutCollectorError;
    private Option<StringBuilder> stderrCollector;
    private Option<Thread> stderrCollectorThread;
    private Option<Exception> stderrCollectorError;

    public CmdProcess() {
        this.READ_BUFFER_SIZE = 1000;
        this.logger().setLogLevel((LogLevel)LogLevel.ERROR$.MODULE$);
        this.wrappedProcess = None$.MODULE$;
        this.shallBeAlive = true;
        this.stdoutCollector = None$.MODULE$;
        this.stdoutCollectorThread = None$.MODULE$;
        this.stdoutCollectorError = None$.MODULE$;
        this.stderrCollector = None$.MODULE$;
        this.stderrCollectorThread = None$.MODULE$;
        this.stderrCollectorError = None$.MODULE$;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int READ_BUFFER_SIZE() {
        return this.READ_BUFFER_SIZE;
    }

    private Process getProcess() {
        Option<Process> option = this.wrappedProcess;
        if (option instanceof Some) {
            Process process = (Process)((Some)option).value();
            return process;
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("process has never been started");
        }
        throw new MatchError(option);
    }

    private boolean getShallBeAlive() {
        boolean bl;
        CmdProcess cmdProcess = this;
        synchronized (cmdProcess) {
            bl = this.shallBeAlive;
        }
        return bl;
    }

    private boolean setShallBeAlive(boolean value) {
        boolean bl;
        CmdProcess cmdProcess = this;
        synchronized (cmdProcess) {
            bl = this.shallBeAlive = value;
        }
        return bl;
    }

    private Thread createStreamReaderThread(InputStream inputStream, StringBuilder collector, boolean errorStream, int readBufferSize) {
        Logger logger = this.logger();
        return new Thread(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private int createStreamReaderThread$default$4() {
        return this.READ_BUFFER_SIZE();
    }

    public void flushOutputs() {
        Option<Thread> option = this.stdoutCollectorThread;
        if (option instanceof Some) {
            Thread thread = (Thread)((Some)option).value();
            thread.join();
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        Option<Thread> option2 = this.stderrCollectorThread;
        if (option2 instanceof Some) {
            Thread thread = (Thread)((Some)option2).value();
            thread.join();
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            return;
        }
        throw new MatchError(option2);
    }

    public CmdProcess setStdoutCollector(StringBuilder collector) {
        this.stdoutCollector = Some$.MODULE$.apply((Object)collector);
        return this;
    }

    public CmdProcess setStderrCollector(StringBuilder collector) {
        this.stderrCollector = Some$.MODULE$.apply((Object)collector);
        return this;
    }

    public CmdProcess start(Process process) {
        this.wrappedProcess = Some$.MODULE$.apply((Object)process);
        this.stdoutCollector.foreach((Function1)(JProcedure1 & Serializable)collector -> {
            this.stdoutCollectorThread = Some$.MODULE$.apply((Object)this.createStreamReaderThread(process.getInputStream(), (StringBuilder)collector, false, this.createStreamReaderThread$default$4()));
            ((Thread)this.stdoutCollectorThread.get()).start();
        });
        this.stderrCollector.foreach((Function1)(JProcedure1 & Serializable)collector -> {
            this.stderrCollectorThread = Some$.MODULE$.apply((Object)this.createStreamReaderThread(process.getErrorStream(), (StringBuilder)collector, false, this.createStreamReaderThread$default$4()));
            ((Thread)this.stderrCollectorThread.get()).start();
        });
        return this;
    }

    public CmdProcess setLogLevel(LogLevel level) {
        this.logger().setLogLevel(level);
        return this;
    }

    public Process getWrappedProcess() {
        return this.getProcess();
    }

    public boolean isAlive() {
        return this.getProcess().isAlive();
    }

    public boolean isAlive(boolean descendants) {
        if (!descendants) {
            return this.getProcess().isAlive();
        }
        return CollectionConverters$.MODULE$.ListHasAsScala(this.getProcess().descendants().toList()).asScala().exists((Function1 & Serializable)_$1 -> _$1.isAlive()) || this.getProcess().isAlive();
    }

    public boolean isAlive$default$1() {
        return false;
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        boolean ret = this.getProcess().waitFor(timeout, unit);
        if (!this.isAlive()) {
            this.flushOutputs();
        }
        return ret;
    }

    public <T> T waitFor(long timeout, TimeUnit unit, Function0<T> onSuccess, Function0<T> onFailure) {
        this.waitFor(timeout, unit);
        if (this.isAlive()) {
            return (T)onSuccess.apply();
        }
        return (T)onFailure.apply();
    }

    public void destroy() {
        this.setShallBeAlive(false);
        this.getProcess().descendants().forEach(processHandle -> processHandle.destroy());
        this.getProcess().destroy();
    }

    public void destroyOrElse(Function0<BoxedUnit> orElse) {
        this.destroyOrElse(100L, TimeUnit.MILLISECONDS, orElse);
    }

    public void destroyOrElse(long gracePeriod, TimeUnit unit, Function0<BoxedUnit> orElse) {
        this.destroy();
        this.waitFor(gracePeriod, unit);
        if (this.isAlive()) {
            orElse.apply$mcV$sp();
            return;
        }
    }

    public void destroyForcibly() {
        this.setShallBeAlive(false);
        this.getProcess().descendants().forEach(processHandle -> processHandle.destroyForcibly());
        this.getProcess().destroyForcibly();
    }

    public String getStdout() {
        Option<StringBuilder> option = this.stdoutCollector;
        if (option instanceof Some) {
            StringBuilder collector = (StringBuilder)((Some)option).value();
            return collector.toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("no in-process stdout collection configured");
        }
        throw new MatchError(option);
    }

    public String getStdErr() {
        Option<StringBuilder> option = this.stderrCollector;
        if (option instanceof Some) {
            StringBuilder collector = (StringBuilder)((Some)option).value();
            return collector.toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("no in-process stderr collection configured");
        }
        throw new MatchError(option);
    }

    public int getExitValue() {
        return this.getProcess().exitValue();
    }
}

